package com.kdgcsoft.jt.xzzf.common.log.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.log.entity.ErrorLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.LoginLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.OperateLog;
import com.kdgcsoft.jt.xzzf.common.log.mapper.LogMapper;
import com.kdgcsoft.jt.xzzf.common.util.SpringContextHolder;

/**
 * 默认日志实现类（数据库方式）
 *
 *
 * @author mapp
 */
public class DefaultLogServiceImpl implements LogService {


    private LogMapper mapper = SpringContextHolder.getBean(LogMapper.class);

    @Override
    public void insertOperateLog(OperateLog log) {
        mapper.insertOperateLog(log);
    }

    @Override
    public Page<OperateLog> queryOperateLog(OperateLog log, int currentPage, int size) {
        return mapper.queryOperateLog(new Page<>(currentPage, size), log);
    }

    @Override
    public void insertLoginLog(LoginLog log) {
        mapper.insertLoginLog(log);
    }

    @Override
    public Page<LoginLog> queryLoginLog(LoginLog log, int currentPage, int size) {
        return mapper.queryLoginLog(new Page<>(currentPage, size), log);
    }

    @Override
    public void insertErrorLog(ErrorLog log) {
        mapper.insertErrorLog(log);
    }

    @Override
    public Page<ErrorLog> queryErrorLog(ErrorLog log, int currentPage, int size) {
        return mapper.queryErrorLog(new Page<>(currentPage, size), log);
    }
}

