package com.kdgcsoft.jt.xzzf.common.log.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.log.entity.ErrorLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.LoginLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.OperateLog;

/**
 * 日志dao层
 *
 * @author mapp
 *
 */
public interface LogMapper {

    /**
     * 插入操作日志
     *
     * @param log
     */
    void insertOperateLog(OperateLog log);

    /**
     * 查询操作日志
     *
     * @param log
     */
    Page<OperateLog> queryOperateLog(Page<OperateLog> page, OperateLog log);

    /**
     * 插入登录日志
     *
     * @param log
     */
    void insertLoginLog(LoginLog log);

    /**
     * 查询登录日志
     *
     * @param log
     */
    Page<LoginLog> queryLoginLog(Page<LoginLog> page, LoginLog log);

    /**
     * 插入异常日志
     *
     * @param log
     */
    void insertErrorLog(ErrorLog log);

    /**
     * 查询异常日志
     *
     * @param log
     */
    Page<ErrorLog> queryErrorLog(Page<ErrorLog> page, ErrorLog log);
}
