package com.kdgcsoft.jt.xzzf.common.log.factory;

import com.kdgcsoft.jt.xzzf.common.enums.OperateType;
import com.kdgcsoft.jt.xzzf.common.log.entity.ErrorLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.LoginLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.OperateLog;
import com.kdgcsoft.jt.xzzf.common.log.service.DefaultLogServiceImpl;
import com.kdgcsoft.jt.xzzf.common.log.service.LogService;
import com.kdgcsoft.jt.xzzf.common.util.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.logging.LogManager;

/**
 * 日志线程任务工厂
 *
 * @author mapp
 */
public class LogRunableFactory {

    private static Logger logger = LoggerFactory.getLogger(LogManager.class);

    private static LogService logService;

    /**
     * 操作日志线程
     *
     * @param mode
     * @param type
     * @param des
     * @param className
     * @param method
     * @param args
     * @param result
     * @param userId
     * @param ip
     * @param subSysId
     * @return
     */
    public static Runnable operateLog(String mode, String des, OperateType type, String className, String method, Object[] args, Object result, String userId, String ip, String subSysId) {
        return () -> {
            try {
//                OperateLog operateLog = LogFactory.createOperateLog(mode, des, type, className, method, args, result, userId, ip, subSysId);
                OperateLog operateLog = LogFactory.createOperateLog(mode, des, type, className, method, args, null, userId, ip, subSysId);
                logService.insertOperateLog(operateLog);
            } catch (Exception e) {
                logger.error("操作日志线程记录失败！错误信息：{}", e.getMessage());
            }
        };
    }

    /**
     * 登录日志线程
     *
     * @param userId
     * @param userName
     * @param ip
     * @param browser
     * @param subSysId
     * @return
     */
    public static Runnable loginLog(String userId, String userName, String ip, String browser, String subSysId) {
        return () -> {
            try {
                LoginLog loginLog = LogFactory.createLoginLog(userId, userName, ip, browser, subSysId);
                logService.insertLoginLog(loginLog);
            } catch (Exception e) {
                logger.error("登录日志线程记录失败！错误信息：{}", e.getMessage());
            }
        };
    }

    /**
     * 异常日志线程
     *
     * @param userId
     * @param className
     * @param method
     * @param args
     * @param errMsg
     * @param subSysId
     * @return
     */
    public static Runnable errorLogin(String userId, String className, String method, Object[] args, String errMsg, String subSysId) {
        return () -> {
            try {
                ErrorLog errorLog = LogFactory.createErrorLog(userId, className, method, args, errMsg, subSysId);
                logService.insertErrorLog(errorLog);
            } catch (Exception e) {
                logger.error("异常日志线程记录失败！错误信息：{}", e.getMessage());
            }
        };
    }


    /**
     *
     * LogService 实现优先使用自定义实现类，从spring容器中获取不到则使用默认实现日志实现类
     *
     *
     */
    static {
        LogService bean = SpringContextHolder.getBean(LogService.class);
        if (bean == null) {
            logService = new DefaultLogServiceImpl();
        } else {
            logService = bean;
        }
    }
}
