package com.kdgcsoft.jt.xzzf.common.log.factory;


import cn.hutool.json.JSONUtil;
import com.kdgcsoft.jt.xzzf.common.enums.OperateType;
import com.kdgcsoft.jt.xzzf.common.log.entity.ErrorLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.LoginLog;
import com.kdgcsoft.jt.xzzf.common.log.entity.OperateLog;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;

import java.util.Date;

/**
 * 日志创建工厂
 *
 * @author mapp
 */
public class LogFactory {


    /**
     * 操作日志
     * @param mode
     * @param des
     * @param type
     * @param method
     * @param args
     * @param result
     * @param ip
     * @param subSysId
     * @return
     */
    public static OperateLog createOperateLog(String mode, String des, OperateType type, String className, String method, Object[] args, Object result, String userId, String ip,String subSysId) {
        String argsStr = "";
        String resultStr = "";
        if (args != null) {
            argsStr = JSONUtil.toJsonPrettyStr(args);
        }
        if (result != null) {
            resultStr = JSONUtil.toJsonPrettyStr(result);
        }

        return OperateLog.builder()
                .id(IDUtil.uuid())
                .model(mode)
                .type(type)
                .des(des)
                .className(className)
                .method(method)
                .args(argsStr)
                .result(resultStr)
                .operateUser(userId)
                .operateTime(new Date())
                .ip(ip)
                .subSysId(subSysId)
                .build();
    }

    /**
     * 登录日志
     * @param userId
     * @param userName
     * @param ip
     * @param browser
     * @param subSysId
     * @return
     */
    public static LoginLog createLoginLog(String userId, String userName, String ip, String browser, String subSysId) {
        return LoginLog.builder()
                .id(IDUtil.uuid())
                .userId(userId)
                .userName(userName)
                .ip(ip)
                .browser(browser)
                .loginTime(new Date())
                .subSysId(subSysId)
                .build();
    }

    /**
     * 异常日志
     * @param userId
     * @param className
     * @param method
     * @param args
     * @param errMsg
     * @return
     */
    public static ErrorLog createErrorLog(String userId, String className, String method, Object[] args, String errMsg, String subSysId) {
        String argsStr = "";
        if (args != null) {
            argsStr = JSONUtil.toJsonPrettyStr(args);
        }
        return ErrorLog.builder()
                .id(IDUtil.uuid())
                .className(className)
                .method(method)
                .args(argsStr)
                .errMsg(errMsg)
                .time(new Date())
                .userId(userId)
                .subSysId(subSysId)
                .build();
    }

}
