package com.kdgcsoft.jt.xzzf.common.log.entity;


import com.kdgcsoft.jt.xzzf.common.enums.OperateType;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *
 * 操作日志实体
 *
 * @author mapp
 *
 */
@Data
@Builder
public class OperateLog implements Serializable {

    /**
     * ID
     */
    private String id;

    /**
     * 模块
     */
    private String model;

    /**
     * 操作类型
     */
    private OperateType type;

    /**
     * 描述
     */
    private String des;

    /**
     * class名称
     */
    private String className;

    /**
     * 方法名称
     */
    private String method;

    /**
     * 方法参数
     */
    private String args;

    /**
     * 方法返回值
     */
    private String result;

    /**
     * 操作人
     */
    private String operateUser;

    /**
     * 操作时间
     */
    private Date operateTime;

    /**
     * ip地址
     */
    private String ip;

    /**
     * 所属子系统
     */
    private String subSysId;

}
