package com.kdgcsoft.jt.xzzf.common.log;

import cn.hutool.core.thread.ThreadFactoryBuilder;

import java.util.concurrent.*;

/**
 * 异步执行日志任务
 *
 *
 * @author mapp
 */
public class AsyncLog {

    private ExecutorService executor = new ThreadPoolExecutor(5,
            20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(),
            new ThreadPoolExecutor.AbortPolicy());

    /**
     * 执行日志任务操作
     *
     * @param runnable
     */
    public void executeLog(Runnable runnable) {
        executor.execute(runnable);
    }

    /**
     * 单例获取
     */
    private static AsyncLog asyncLog = new AsyncLog();
    public static AsyncLog getInstance() {
        return asyncLog;
    }
    private AsyncLog() {
    }
}
