package com.kdgcsoft.jt.xzzf.common.generator;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;

import java.util.Arrays;

/**
 * 扩展名称转换
 *
 * @author mapp
 */
public class MyCovert implements INameConvert {

    @Override
    public String entityNameConvert(TableInfo tableInfo) {
        return capitalFirst(underlineToCamel(removePrefix(tableInfo.getName())));
    }

    @Override
    public String propertyNameConvert(TableField field) {
        return underlineToCamel(field.getName());
    }

    /**
     * 去除表名前缀
     * @param name
     * @return
     */
    public String removePrefix(String name) {
        if (StrUtil.isEmpty(name)) {
            return "";
        } else {
            String tempName = name.toLowerCase();
            if (tempName.startsWith("c_") || tempName.startsWith("b_") || tempName.startsWith("f_")
                    || tempName.startsWith("r_") || tempName.startsWith("t_") || tempName.startsWith("l_")
                    || tempName.startsWith("s_") || tempName.startsWith("d_") || tempName.startsWith("v_")
                    || tempName.startsWith("m_")) {

                return tempName.substring(2);
            }
            return tempName;
        }
    }


    public String underlineToCamel(String name) {
        if (StrUtil.isEmpty(name)) {
            return "";
        } else {
            String tempName = name;
            if (StringUtils.isCapitalMode(name) || StringUtils.isMixedMode(name)) {
                tempName = name.toLowerCase();
            }

            StringBuilder result = new StringBuilder();
            String[] camels = tempName.split("_");
            Arrays.stream(camels).filter((camel) -> {
                return !StrUtil.isEmpty(camel);
            }).forEach((camel) -> {
                if (result.length() == 0) {
                    result.append(camel);
                } else {
                    result.append(capitalFirst(camel));
                }

            });
            return result.toString();
        }
    }

    public  String capitalFirst(String name) {
        return StrUtil.isNotEmpty(name) ? name.substring(0, 1).toUpperCase() + name.substring(1) : "";
    }

}
