package com.kdgcsoft.jt.xzzf.common.file.util;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.file.entity.FileParamsVo;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;

/****
 * @className FileUtil
 * @author ChrisYolanda
 * @description 文件工具类
 * @version 1.0
 * @date 2020-08-21 00:27
 */
public class FileUtil extends cn.hutool.core.io.FileUtil {

    /*******
     * 验证文件类型是否符合
     * @param accepts 限制的文件类型
     * @param fileType 上传的文件类型
     * @return
     */
    public static boolean verifyFileAccept(String accepts, String fileType) {
        if (BeanUtils.isNotEmpty(accepts) && BeanUtils.isNotEmpty(fileType)) {
            if (FileParamsVo.DEF_ACCEPT_LIMIT.equals(accepts.toLowerCase())) {
                return true;
            } else {
                String[] acceptList = StrUtil.split(accepts, StrUtil.COMMA);
                if (BeanUtils.isNotEmpty(acceptList)) {
                    for (String apt : acceptList) {
                        if (apt.equalsIgnoreCase(fileType)) {
                            return true;
                        }
                    }
                    return false;
                } else {
                    return true;
                }
            }
        } else {
            return true;
        }
    }
}
