package com.kdgcsoft.jt.xzzf.common.file.entity;

import lombok.Data;

/****
 * @className FileParamsVo
 * @author chris
 * @description 文件参数实体类Vo
 * @version 1.0
 * @date 2020-07-07 19:01
 */
@Data
@SuppressWarnings("serial")
public class FileParamsVo {

    /****
     * 默认的文件类型限制
     */
    public static final String DEF_ACCEPT_LIMIT = "*";

    /****
     * 附件来源方式
     * 01-ftp服务器
     * 02-文件服务器
     */
    public static final String FILE_SOURCE_TYPE_01 = "01";
    public static final String FILE_SOURCE_TYPE_02 = "02";

    /*******
     * 附件所属标识
     */
    private String attachType;

    /*******
     * 限制上传文件的格式,以逗号(,)分隔
     */
    private String accepts;

    /******
     * 文件夹是否按照日期去进行分类
     */
    private boolean attachByDate = true;

    /******
     * 文件是否使用旧名称
     */
    private boolean useOldName = false;

    /*******
     * 附件来源方式
     */
    private String sourceType;

    /******
     * 附件类别
     */
    private String category;
}
