package com.kdgcsoft.jt.xzzf.common.file.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.constant.FtpConstants;
import com.kdgcsoft.jt.xzzf.common.exception.BusinessException;
import com.kdgcsoft.jt.xzzf.common.file.entity.FileParamsVo;
import com.kdgcsoft.jt.xzzf.common.file.util.FileUtil;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.FtpUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.power.fileconverter.*;
import lombok.extern.log4j.Log4j2;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/****
 * @className FileServletController
 * @author chris
 * @description 文件控制层
 * @version 1.0
 * @date 2020-04-08 10:50
 */
@Log4j2
@RestController
@RequestMapping("/file")
public class FileServletController {

    @Resource
    private XzzfProperties xzzfProperties;

    /******
     * 附件上传
     * @param file 文件
     * @param entity 文件附加参数
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/uploadFile", produces = {"application/json;charset=UTF-8"})
    public Result uploadFile(@RequestParam("file") MultipartFile file, FileParamsVo entity) throws IOException {
        if (BeanUtils.isNotEmpty(xzzfProperties.getModelCode())) {
            //初始附件实体类
            AttachmentVo dbAttachment = new AttachmentVo();
            //主键Id
            dbAttachment.setId(IDUtil.uuid());
            //附件原始名称
            dbAttachment.setOldFileName(file.getOriginalFilename());
            //附件类型(文件类型)
            dbAttachment.setFileType(file.getContentType().substring(0, file.getContentType().lastIndexOf(StrUtil.SLASH)));
            //赋值附件类别
            dbAttachment.setFileCategory(AttachmentVo.ATTACHMENT_CATEGORY_01);
            //赋值文件后缀名
            dbAttachment.setFileSuffix(dbAttachment.getOldFileName().substring(dbAttachment.getOldFileName().lastIndexOf(StrUtil.DOT) + 1));
            //附件上传基础路径
            String savePath = FtpConstants.FILE_UPLOAD + xzzfProperties.getModelCode() + StrUtil.SLASH;

            // 赋值文件其他信息
            if (dbAttachment.getOldFileName().contains(StrUtil.DOT)) {
                String newFileName = dbAttachment.getId() + dbAttachment.getOldFileName().substring(dbAttachment.getOldFileName().lastIndexOf(StrUtil.DOT));
                //附件新名称
                dbAttachment.setNewFileName(newFileName);
                //附件存储路径
                dbAttachment.setFilePath(savePath + newFileName);
            }

            //拼接附件上传自定义路径
            if (BeanUtils.isNotEmpty(entity)) {
                //判断文件类型限制是否符合
                boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbAttachment.getFileSuffix());
                if (!verify) {
                    return Result.fail("文件类型不匹配,请重新上传");
                }

                //附件分类标识
                if (BeanUtils.isNotEmpty(entity.getAttachType())) {
                    savePath = (savePath + entity.getAttachType() + StrUtil.SLASH);
                    //附件存储路径
                    dbAttachment.setFilePath(savePath + dbAttachment.getNewFileName());
                }

                // 存储路径是否按年月日创建文件夹目录
                if (entity.isAttachByDate()) {
                    //附件存储路径加上年月日
                    savePath = savePath + DateUtil.format(new Date(), "yyyy") + StrUtil.SLASH + DateUtil.format(new Date(), "MM") + StrUtil.SLASH + DateUtil.format(new Date(), "dd") + StrUtil.SLASH;
                    //附件存储路径
                    dbAttachment.setFilePath(savePath + dbAttachment.getNewFileName());
                }

                //判断是否使用旧名称
                if (entity.isUseOldName()) {
                    //附件新名称
                    dbAttachment.setNewFileName(dbAttachment.getOldFileName());
                    //附件存储路径
                    dbAttachment.setFilePath(savePath + dbAttachment.getOldFileName());
                }

                //赋值公共路径信息
                dbAttachment.setFilePubPath(savePath);

                //赋值附件类别
                dbAttachment.setFileCategory(entity.getCategory());
            }

            // 上传到Ftp服务器上
            boolean uploadFile = FtpUtil.upload(savePath, dbAttachment.getNewFileName(), file.getInputStream());
            if (uploadFile) {
                // 附件上传成功返回附件信息
                System.out.println("附件的相关信息:" + dbAttachment.toString());
                return Result.success(dbAttachment);
            } else {
                return Result.fail("附件上传失败");
            }
        } else {
            return Result.fail("子系统类型不能为空");
        }
    }

    /******
     * 批量上传文件
     * @param files
     * @param entity
     * @return
     * @throws IOException
     */
    @PostMapping("/uploadFileList")
    public Result uploadFileList(@RequestParam("files") MultipartFile[] files, FileParamsVo entity) throws IOException {
        List list = new ArrayList();
        for (MultipartFile file : files) {
            if (BeanUtils.isNotEmpty(xzzfProperties.getModelCode())) {
                //初始附件实体类
                AttachmentVo dbAttachment = new AttachmentVo();
                //主键Id
                dbAttachment.setId(IDUtil.uuid());
                // 附件原始名称
                dbAttachment.setOldFileName(file.getOriginalFilename());
                //附件类型
                dbAttachment.setFileType(file.getContentType().substring(0, file.getContentType().lastIndexOf(StrUtil.SLASH)));
                //赋值附件类别
                dbAttachment.setFileCategory(AttachmentVo.ATTACHMENT_CATEGORY_01);
                //赋值文件后缀名
                dbAttachment.setFileSuffix(dbAttachment.getOldFileName().substring(dbAttachment.getOldFileName().lastIndexOf(StrUtil.DOT) + 1));
                //附件上传基础路径
                String savePath = FtpConstants.FILE_UPLOAD + xzzfProperties.getModelCode() + StrUtil.SLASH;
                // 赋值文件其他信息
                if (dbAttachment.getOldFileName().contains(StrUtil.DOT)) {
                    String newFileName = dbAttachment.getId() + dbAttachment.getOldFileName().substring(dbAttachment.getOldFileName().lastIndexOf(StrUtil.DOT));
                    //附件新名称
                    dbAttachment.setNewFileName(newFileName);
                    //附件存储路径
                    dbAttachment.setFilePath(savePath + newFileName);
                }
                //拼接附件上传自定义路径
                if (BeanUtils.isNotEmpty(entity)) {
                    //判断文件类型限制是否符合
                    boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbAttachment.getFileSuffix());
                    if (!verify) {
                        return Result.fail("文件类型不匹配,请重新上传");
                    }

                    //附件分类标识
                    if (BeanUtils.isNotEmpty(entity.getAttachType())) {
                        savePath = (savePath + entity.getAttachType() + StrUtil.SLASH);
                        //附件存储路径
                        dbAttachment.setFilePath(savePath + dbAttachment.getNewFileName());
                    }

                    // 存储路径是否按年月日创建文件夹目录
                    if (entity.isAttachByDate()) {
                        //附件存储路径加上年月日
                        savePath = savePath + DateUtil.format(new Date(), "yyyy") + StrUtil.SLASH + DateUtil.format(new Date(), "MM") + StrUtil.SLASH + DateUtil.format(new Date(), "dd") + StrUtil.SLASH;
                        //附件存储路径
                        dbAttachment.setFilePath(savePath + dbAttachment.getNewFileName());
                    }

                    //判断是否使用旧名称
                    if (entity.isUseOldName()) {
                        //附件新名称
                        dbAttachment.setNewFileName(dbAttachment.getOldFileName());
                        //附件存储路径
                        dbAttachment.setFilePath(savePath + dbAttachment.getOldFileName());
                    }

                    //赋值公共路径信息
                    dbAttachment.setFilePubPath(savePath);

                    //赋值附件类别
                    dbAttachment.setFileCategory(entity.getCategory());
                }

                // 上传到Ftp服务器上
                boolean uploadFile = FtpUtil.upload(savePath, dbAttachment.getNewFileName(), file.getInputStream());
                if (uploadFile) {
                    // 附件上传成功返回附件信息
                    System.out.println("附件的相关信息:" + dbAttachment.toString());
                    list.add(dbAttachment);
                } else {
                    return Result.fail("附件上传失败");
                }
            } else {
                return Result.fail("子系统类型不能为空");
            }
        }
        return Result.success(list);
    }

    /******
     * 附件下载
     * @param path 附件路径
     * @param name 附件名称
     * @param downloadName 下载附件的名称
     * @param response
     * @throws IOException
     */
    @RequestMapping("/downloadFile")
    public void fileDownLoad(String path, String name, String downloadName, HttpServletResponse response) {
        if (BeanUtils.isNotEmpty(path) && BeanUtils.isNotEmpty(name)) {
            try {
                // 附件保存路径
                path = URLDecoder.decode(path, "UTF-8");

                // 附件名称
                if (BeanUtils.isNotEmpty(downloadName)) {
                    name = URLDecoder.decode(downloadName, "UTF-8");
                } else {
                    name = URLDecoder.decode(name, "UTF-8");
                }

                // 保存在ftp上的附件名
                String fileName = "";
                // ftp上的路径
                String filePath = "";
                if (path.contains(StrUtil.SLASH)) {
                    filePath += path.substring(0, path.lastIndexOf(StrUtil.SLASH));
                    fileName = path.substring(path.lastIndexOf(StrUtil.SLASH) + 1);
                } else {
                    fileName = path;
                }
                // 清空response
                response.reset();
                //不设置此语句，则successCallback回调函数失效
                response.setHeader("Set-Cookie", "fileDownload=true; path=/");
                //设置文件下载是以附件的形式下载
                response.setHeader("Content-disposition", "attachment; filename=" + new String(name.getBytes("UTF-8"), "ISO8859-1"));
                response.setHeader("Content-Type", "application/octet-stream");
                ServletOutputStream sos = response.getOutputStream();
                ByteArrayInputStream in = null;
                ByteArrayOutputStream out = new ByteArrayOutputStream();

                //获取文件流
                boolean res = FtpUtil.downLoad(filePath, fileName, out);
                if (res) {
                    // 文件输入流
                    in = new ByteArrayInputStream(out.toByteArray());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = in.read(buffer)) != -1) {
                        sos.write(buffer, 0, len);
                    }
                    // 冲刷流
                    out.flush();
                    sos.flush();
                    sos.close();
                    out.close();
                    in.close();
                } else {
                    throw new BusinessException("附件信息不存在");
                }
            } catch (Exception e) {
                log.error("附件下载失败");
                e.printStackTrace();
            } finally {

            }
        } else {
            throw new BusinessException("缺少关键信息,请重试");
        }
    }

    /******
     * 播放视频附件
     * @param path
     * @param name
     * @param request
     * @param response
     */
    @RequestMapping("/playVideoFile")
    public void playVideo(@RequestParam("path") String path, @RequestParam("name") String name, HttpServletRequest request, HttpServletResponse response) {
        if (BeanUtils.isNotEmpty(path) && BeanUtils.isNotEmpty(name)) {
            try {
                // 附件保存路径
                path = URLDecoder.decode(path, "UTF-8");
                // 附件名称
                name = URLDecoder.decode(name, "UTF-8");
                // 保存在ftp上的附件名
                String fileName = "";
                // ftp上的路径
                String filePath = "";
                if (path.contains(StrUtil.SLASH)) {
                    filePath += path.substring(0, path.lastIndexOf(StrUtil.SLASH));
                    fileName = path.substring(path.lastIndexOf(StrUtil.SLASH) + 1);
                } else {
                    fileName = path;
                }

                //初始化定义字节输出流
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                boolean res = FtpUtil.downLoad(filePath, fileName, out);
                if (res) {
                    // 文件输入流
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    //重置response
                    response.reset();
                    //获取从那个字节开始读取文件
                    String rangeString = request.getHeader("Range");
                    System.out.println("=======rangeString:" + rangeString);
                    ServletOutputStream sos = response.getOutputStream();

                    //定义文件全部路径
                    String fullPath = "/temp/" + name;
                    File file = FileUtil.writeFromStream(in, fullPath);
                    System.out.println("==========fullPath:" + fullPath);
                    RandomAccessFile targetFile = new RandomAccessFile(file, "r");
                    long fileLength = targetFile.length();
                    //播放
                    if (BeanUtils.isNotEmpty(rangeString)) {
                        long range = Long.valueOf(rangeString.substring(rangeString.indexOf("=") + 1, rangeString.indexOf("-")));
                        //设置内容类型
                        response.setHeader("Content-Type", "video/mp4");
                        //设置此次相应返回的数据长度
                        response.setHeader("Content-Length", String.valueOf(fileLength - range));
                        //设置此次相应返回的数据范围
                        response.setHeader("Content-Range", "bytes " + range + "-" + (fileLength - 1) + "/" + fileLength);
                        //返回码需要为206，而不是200
                        response.setStatus(HttpServletResponse.SC_PARTIAL_CONTENT);
                        //设定文件读取开始位置（以字节为单位）
                        targetFile.seek(range);
                        byte[] cache = new byte[1024 * 300];
                        int length = 0;
                        while ((length = targetFile.read(cache)) != -1) {
                            sos.write(cache, 0, length);
                        }
                    }
                    //关闭文件流信息
                    sos.flush();
                    sos.close();
                    out.flush();
                    out.close();
                    in.close();
                    targetFile.close();
                    //删除文件
                    FileUtil.del(file);
                } else {
                    throw new BusinessException("附件信息不存在");
                }
            } catch (IOException e) {
                log.error("附件下载失败");
                e.printStackTrace();
            } finally {

            }
        } else {
            throw new BusinessException("缺少关键信息,请重试");
        }
    }


    /******
     * 文件转PDF
     * @param infoId 文件信息Id
     * @param path 文件路径
     * @param name 文件名称
     * @param sourceType 文件来源:01-ftp服务器,02-文件服务器
     * @param request
     * @param response
     */
    @RequestMapping("/fileToPdf")
    public void officeFileToPdfFile(String infoId, String path, String name, String sourceType, HttpServletRequest request, HttpServletResponse response) {
        if (BeanUtils.isNotEmpty(sourceType)) {
            //来源于ftp服务器
            if (FileParamsVo.FILE_SOURCE_TYPE_01.equals(sourceType)) {
                if (BeanUtils.isNotEmpty(path) && BeanUtils.isNotEmpty(name)) {
                    //下载文件信息
                    try {
                        // 附件保存路径
                        path = URLDecoder.decode(path, "UTF-8");
                        // 附件名称
                        name = URLDecoder.decode(name, "UTF-8");
                        // 保存在ftp上的附件名
                        String fileName = "";
                        // ftp上的路径
                        String filePath = "";
                        if (path.contains(StrUtil.SLASH)) {
                            filePath += path.substring(0, path.lastIndexOf(StrUtil.SLASH));
                            fileName = path.substring(path.lastIndexOf(StrUtil.SLASH) + 1);
                        } else {
                            fileName = path;
                        }

                        //初始化定义字节输出流
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        boolean res = FtpUtil.downLoad(filePath, fileName, out);
                        if (res) {
                            // 文件输入流
                            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                            //重置response
                            response.reset();
                            //设置内容类型
                            response.setHeader("Content-Type", "application/pdf");
                            //定义文件全部路径
                            String fullPath = "/temp/" + name;
                            File file = FileUtil.writeFromStream(in, fullPath);
                            System.out.println("==========fullPath:" + fullPath);

                            //删除文件
                            FileUtil.del(file);
                        } else {
                            throw new BusinessException("附件信息不存在");
                        }
                    } catch (IOException e) {
                        log.error("附件下载失败");
                        e.printStackTrace();
                    } finally {

                    }
                } else {
                    throw new BusinessException("缺少关键信息,请重试");
                }
            }

            //来源于文件服务器
            if (FileParamsVo.FILE_SOURCE_TYPE_02.equals(sourceType)) {
                if (BeanUtils.isNotEmpty(infoId)) {

                } else {
                    throw new BusinessException("缺少关键信息,请重试");
                }
            }
        } else {
            throw new BusinessException("缺少关键信息,请重试");
        }
    }

    public static void main(String[] args) {
        FileConverterSettings settings = new FileConverterSettings();
        settings.setOffice2PdfEngine(Office2PdfEngineType.MSOFFICE);
        settings.setStorageType(StorageType.UUID);
        try {
            settings.setWorkdir(new File("E:\\other"));
            FileConverterService.init(settings);
        } catch (IOException e) {
            log.error("文档转换器初始化失败！请检查配置文件！", e);
            System.exit(-1);
        }

        try {
            FileConverterService.convert(new File("E:\\other\\333.docx"), "2133", OutputType.PDF, false);
        } catch (FileConverterException e) {
            e.printStackTrace();
        }
    }
}
