package com.kdgcsoft.jt.xzzf.common.file.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.config.OttsProperties;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.file.entity.FileParamsVo;
import com.kdgcsoft.jt.xzzf.common.file.util.FileUtil;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.io.FileUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/****
 * @className FileManagerServletController
 * @author chris
 * @description 文件服务器文件上传控制器
 * @version 1.0
 * @date 2021-04-03 15:30
 */
@Log4j2
@RestController
@RequestMapping("/fileManager")
public class FileManagerServletController {

    @Resource
    private XzzfProperties xzzfProperties;

    @Resource
    private OttsProperties ottsProperties;

    /********
     * 文件上传
     * @param file
     */
    @RequestMapping("/fileUpload")
    public Result upload(@RequestParam("file") MultipartFile file, FileParamsVo entity) {
        if (BeanUtils.isNotEmpty(xzzfProperties.getModelCode())) {
            //初始附件实体类
            AttachmentVo dbEntity = new AttachmentVo();
//            Map<String, Object> dataMap = new HashMap();
            if (BeanUtils.isNotEmpty(file)) {
                //主键Id
                dbEntity.setId(IDUtil.uuid());
                // 附件原始名称
                dbEntity.setOldFileName(file.getOriginalFilename());
                //附件类型
                dbEntity.setFileType(file.getContentType().substring(0, file.getContentType().lastIndexOf(StrUtil.SLASH)));
                //赋值文件后缀名
                dbEntity.setFileSuffix(dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(StrUtil.DOT) + 1));
                if (BeanUtils.isNotEmpty(entity)) {
                    //判断文件类型限制是否符合
                    boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbEntity.getFileSuffix());
                    if (!verify) {
                        return Result.fail("文件类型不匹配,请重新上传");
                    }

                    // 保存到ftp用uuid作为附件名
                    if (dbEntity.getOldFileName().contains(StrUtil.DOT)) {
                        //判断是否使用旧名称
                        if (entity.isUseOldName()) {
                            //附件新名称
                            dbEntity.setNewFileName(dbEntity.getOldFileName());
                        } else {
                            String newFileName = dbEntity.getId() + dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(StrUtil.DOT));
                            //附件新名称
                            dbEntity.setNewFileName(newFileName);
                        }
                    }
                }
                //创建临时文件
                File tmpFile = new File(dbEntity.getNewFileName());
                try {
                    //获取token
                    String token = this.getFileManagerToken();
                    if (BeanUtils.isNotEmpty(token)) {
                        FileUtils.copyInputStreamToFile(file.getInputStream(), tmpFile);
                        Map<String, Object> paramMap = new HashMap<>();
                        paramMap.put("file", tmpFile);
                        paramMap.put("token", token);
                        String res = HttpUtil.post(ottsProperties.getFileManagerUrl() + "putFile", paramMap);
                        JSONObject resObj = JSONUtil.parseObj(res);
                        if (resObj.getBool("success")) {
                            //赋值旧名称
                            dbEntity.setOldFileName(dbEntity.getOldFileName());
                            //赋值新名称
                            dbEntity.setNewFileName(dbEntity.getNewFileName());
                            //赋值文件路径
                            dbEntity.setFilePath(String.valueOf(resObj.getStr("data")));
//                            dataMap.put("fileKey",resObj.getStr("data") );
//                            dataMap.put("fileName", fileName);
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                    return Result.fail("文件上传失败");
                } finally {
                    //删除临时文件
                    tmpFile.delete();
                }
            } else {
                Result.fail("文件不能为空");
            }
            return Result.success(dbEntity);
        } else {
            return Result.fail("子系统类型不能为空");
        }
    }

    /*******
     * 文件预览
     * @param key
     * @param response
     */
    @RequestMapping("/preview")
    public void preview(String key, HttpServletResponse response) {
        //获取token
        String token = this.getFileManagerToken();
        if (BeanUtils.isNotEmpty(token)) {
            try {
                response.sendRedirect(ottsProperties.getFileManagerUrl() + "filePreview/preview?key=" + key + "&token=" + token);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /******
     * 文件删除
     * @param key
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String key) {
        //获取token
        String token = this.getFileManagerToken();
        if (BeanUtils.isNotEmpty(token)) {
            String resJson = HttpUtil.get(ottsProperties.getFileManagerUrl() + "deleteFile?key=" + key + "&token=" + token);
            JSONObject resObj = JSONUtil.parseObj(resJson);
            if (resObj.getBool("success")) {
                return Result.msg("删除成功");
            } else {
                return Result.msg("删除失败");
            }
        } else {
            return Result.msg("获取验证失败,请稍后再试");
        }
    }

    /*******
     * 文件下载
     * @param key
     * @param response
     */
    @RequestMapping("/downloadFile")
    public void downLoad(String key, HttpServletResponse response) {
        //获取token
        String token = this.getFileManagerToken();
        if (BeanUtils.isNotEmpty(token)) {
            try {
                response.sendRedirect(ottsProperties.getFileManagerUrl() + "filePreview/download?key=" + key + "&token=" + token);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /********
     * 查询文件
     * @param key
     * @param response
     */
    @RequestMapping("/queryFile")
    public void queryFile(String key, HttpServletResponse response) {
        try {
            //获取token
            String token = this.getFileManagerToken();
            if (BeanUtils.isNotEmpty(token)) {
                Map<String, Object> paramMap = new HashMap<>();
                paramMap.put("key", key);
                paramMap.put("token", token);
                byte[] bytes = HttpRequest.post(ottsProperties.getFileManagerUrl() + "file/getByKey").form(paramMap).timeout(-1).execute().bodyBytes();
                OutputStream stream = new BufferedOutputStream(response.getOutputStream());
                response.setContentType("application/octet-stream");
                stream.write(bytes);
                stream.flush();
                stream.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*****
     * 获取文件服务器的token值
     * @return
     */
    private String getFileManagerToken() {
        if (BeanUtils.isNotEmpty(ottsProperties.getFileManagerUrl()) && BeanUtils.isNotEmpty(ottsProperties.getFileManagerAppCode())) {
            String tokenJson = HttpUtil.get(ottsProperties.getFileManagerUrl() + "getValidToken?appcode=" + ottsProperties.getFileManagerAppCode());
            JSONObject jsonObject = JSONUtil.parseObj(tokenJson);
            if (jsonObject.getBool("success")) {
                return jsonObject.getStr("data");
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
}
