package com.kdgcsoft.jt.xzzf.common.file.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.google.gson.Gson;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.constant.FtpConstants;
import com.kdgcsoft.jt.xzzf.common.file.entity.FileParamsVo;
import com.kdgcsoft.jt.xzzf.common.file.util.FileUtil;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.FtpUtil;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/****
 * @className FileEditorServletController
 * @author ChrisYolanda
 * @description 富文本编辑器文件上传控制器
 * @version 1.0
 * @date 2020-08-21 15:58
 */
@Log4j2
@RestController
@RequestMapping("/fileEditor")
public class FileEditorServletController {

    @Resource
    private XzzfProperties xzzfProperties;

    @Resource
    private ShiroCasProperties shiroCasProperties;

    /******
     * 附件上传
     * @param file 文件
     * @param request
     * @param response
     * @param entity 文件附加参数
     * @return
     * @throws IOException
     */
    @PostMapping("/uploadFile")
    public void uploadFile(@RequestParam("file") MultipartFile file, HttpServletRequest request, HttpServletResponse response, FileParamsVo entity) throws IOException {
        request.setCharacterEncoding("UTF-8");
        if (BeanUtils.isNotEmpty(xzzfProperties.getModelCode())) {
            //初始附件实体类
            AttachmentVo dbEntity = new AttachmentVo();
            //主键Id
            dbEntity.setId(IDUtil.uuid());
            // 附件原始名称
            dbEntity.setOldFileName(file.getOriginalFilename());
            //赋值文件后缀名
            dbEntity.setFileSuffix(dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(StrUtil.DOT) + 1));
            //附件上传基础路径
            String savePath = FtpConstants.FILE_UPLOAD + xzzfProperties.getModelCode() + StrUtil.SLASH;
            //拼接附件上传自定义路径
            if (BeanUtils.isNotEmpty(entity)) {
                //判断文件类型限制是否符合
                boolean verify = FileUtil.verifyFileAccept(entity.getAccepts(), dbEntity.getFileSuffix());
                if (!verify) {
                    log.info("文件类型不匹配,请重新上传");
                }

                //附件分类标识
                if (BeanUtils.isNotEmpty(entity.getAttachType())) {
                    savePath = (savePath + entity.getAttachType() + StrUtil.SLASH);
                }

                // 存储路径是否按年月日创建文件夹目录
                if (entity.isAttachByDate()) {
                    //附件存储路径加上年月日
                    savePath = savePath + DateUtil.format(new Date(), "yyyy") + StrUtil.SLASH + DateUtil.format(new Date(), "MM") + StrUtil.SLASH + DateUtil.format(new Date(), "dd") + StrUtil.SLASH;
                }
            }

            // 保存到ftp用uuid作为附件名
            if (dbEntity.getOldFileName().contains(StrUtil.DOT)) {
                //判断是否使用旧名称
                if (entity.isUseOldName()) {
                    //附件新名称
                    dbEntity.setNewFileName(dbEntity.getOldFileName());
                    //附件存储路径
                    dbEntity.setFilePath(savePath + dbEntity.getOldFileName());
                } else {
                    String newFileName = dbEntity.getId() + dbEntity.getOldFileName().substring(dbEntity.getOldFileName().lastIndexOf(StrUtil.DOT));
                    //附件新名称
                    dbEntity.setNewFileName(newFileName);
                    //附件存储路径
                    dbEntity.setFilePath(savePath + newFileName);
                }
            }

            // 上传到Ftp服务器上
            boolean uploadFile = FtpUtil.upload(savePath, dbEntity.getNewFileName(), file.getInputStream());
            if (uploadFile) {
                Map<String, String> map = new HashMap<>();
                // 附件上传成功返回附件信息
                System.out.println("附件的相关信息:" + dbEntity.toString());
                map.put("link", shiroCasProperties.getService() + "file/downloadFile?path=" + dbEntity.getFilePath() + "&name=" + dbEntity.getNewFileName());
                Gson gson = new Gson();
                response.getWriter().write(gson.toJson(map));
            } else {
                log.info("附件上传失败");
            }
        } else {
            log.info("子系统类型不能为空");
        }
    }
}
