package com.kdgcsoft.jt.xzzf.common.excel.jxls;

import com.kdgcsoft.jt.xzzf.common.exception.BusinessException;
import jxl.WorkbookSettings;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.ss.usermodel.Workbook;

import java.io.*;
import java.util.Map;

/****
 * @className XlsTransformerExt
 * @author chris
 * @description
 * @version 1.0
 * @date 2020-04-09 22:00
 */
public class XlsTransformerExt extends XLSTransformer {

    /*******
     * 转换
     * @param srcFilePath 文件路径
     * @param beanParams Map对象
     * @param os 文件输出流
     * @param operateTypeText 操作类型:导入或者导出
     */
    public void transformXLS(String srcFilePath, Map<String, Object> beanParams, OutputStream os, String operateTypeText) {
        try {
            //判断模板文件是否存在
            File tempFile = new File(srcFilePath);
            if (!tempFile.exists()) {
                throw new BusinessException(operateTypeText + "模板文件不存在!");
            }
            InputStream is = new BufferedInputStream(new FileInputStream(srcFilePath));
            WorkbookSettings wbs = new WorkbookSettings();
            //禁用GC，能大大加快Excel的导出速度
            wbs.setGCDisabled(true);
            Workbook workbook = transformXLS(is, beanParams);
            workbook.write(os);
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(operateTypeText + "失败:" + e.getMessage());
        }
    }
}
