package com.kdgcsoft.jt.xzzf.common.excel.easy;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;

import java.util.ArrayList;
import java.util.List;

/****
 * @className ExcelListener
 * @author chris
 * @description Excel监听
 * @version 1.0
 * @date 2020-07-28 17:43
 */
public class ExcelListener extends AnalysisEventListener {

    /****
     * 自定义用于暂时存储data
     */
    private List<Object> datas = new ArrayList<>();

    /*******
     * 通过 AnalysisContext 对象还可以获取当前 sheet，当前行等数据
     * @param obj
     * @param analysisContext
     */
    @Override
    public void invoke(Object obj, AnalysisContext analysisContext) {
        System.out.println("解析到一条数据:{ " + obj.toString() + " }");
        datas.add(obj);
    }

    /**
     * 读取完之后的操作
     */
    @Override
    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        System.out.println("所有数据解析完成！");
    }

    public List<Object> getDatas() {
        return datas;
    }

    public void setDatas(List<Object> datas) {
        this.datas = datas;
    }
}
