package com.kdgcsoft.jt.xzzf.common.excel.easy;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/****
 * @className EasyExcelUtil
 * @author chris
 * @description Excel工具类
 * @version 1.0
 * @date 2020-07-28 17:45
 */
public class EasyExcelUtil {

    /*****
     * excel默认后缀名:2007:xlsx,2003:xls
     */
    public static final String EXCEL_DEF_SUFFIX_2007 = "xlsx";
    public static final String EXCEL_DEF_SUFFIX_2003 = "xls";

    /**
     * 读取某个 sheet 的 Excel
     *
     * @param file     文件
     * @param rowModel 实体类映射，继承 BaseRowModel 类
     * @return Excel 数据 list
     */
    public static List<Object> readExcel(MultipartFile file, BaseRowModel rowModel){
        try {
            return EasyExcelUtil.readExcel(file, rowModel, 1, 1);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 读取某个 sheet 的 Excel
     *
     * @param file        文件
     * @param rowModel    实体类映射，继承 BaseRowModel 类
     * @param sheetNo     sheet 的序号 从1开始
     * @param headLineNum 表头行数，默认为1
     * @return Excel 数据 list
     */
    public static List<Object> readExcel(MultipartFile file, BaseRowModel rowModel, int sheetNo, int headLineNum) throws IOException {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = EasyExcelUtil.getReader(file, excelListener);
        if (reader == null) {
            return null;
        }
        reader.read(new Sheet(sheetNo, headLineNum, rowModel.getClass()));
        return excelListener.getDatas();
    }

    /**
     * 读取指定sheetName的Excel(多个 sheet)
     *
     * @param file     文件
     * @param rowModel 实体类映射，继承 BaseRowModel 类
     * @param sheetName sheetName名称
     * @return Excel 数据 list
     * @throws IOException
     */
    public static List<Object> readExcel(MultipartFile file, BaseRowModel rowModel, String sheetName) throws IOException {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = EasyExcelUtil.getReader(file, excelListener);
        if (reader == null) {
            return null;
        }
        for (Sheet sheet : reader.getSheets()) {
            if (rowModel != null) {
                sheet.setClazz(rowModel.getClass());
            }
            //读取指定名称的sheet
            if (sheet.getSheetName().contains(sheetName)) {
                reader.read(sheet);
                break;
            }
        }
        return excelListener.getDatas();
    }

    /**
     * 返回 ExcelReader
     *
     * @param file          需要解析的 Excel 文件
     * @param excelListener new ExcelListener()
     * @throws IOException
     */
    private static ExcelReader getReader(MultipartFile file, ExcelListener excelListener) throws IOException {
        String fileName = file.getOriginalFilename();
        if (BeanUtils.isNotEmpty(fileName)) {
            if ((fileName.toLowerCase().endsWith(StrUtil.DOT + EXCEL_DEF_SUFFIX_2007) || fileName.toLowerCase().endsWith(StrUtil.DOT + EXCEL_DEF_SUFFIX_2003))) {
                InputStream is = new BufferedInputStream(file.getInputStream());
                return new ExcelReader(is, null, excelListener, false);
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    /*****
     * 校验文件与模板文件信息
     * @param file
     * @param tempFilePath
     */
    private static void verify(MultipartFile file, String tempFilePath) {

    }
}
