package com.kdgcsoft.jt.xzzf.common.entity;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 在线用户
 *
 * @author mpp
 */
@Data
public class OnLineUser implements Serializable {

    /****
     * 用户账号
     */
    private String userName;
    /****
     * 用户名称
     */
    private String name;
    /****
     *电话号码
     */
    private String tel;
    /**
     * tgt
     */
    private String tgt;
    /**
     * 状态
     * 0：在线
     * 1；离线
     */
    private String status;
    /****
     * IP地址
     */
    private String ip;
    /****
     * 浏览器
     */
    private String browser;
    /**
     * 区划编码
     */
    private String areaCode;
    /****
     *区划名称
     */
    private String areaName;
    /****
     *登录时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date loginTime;
}
