package com.kdgcsoft.jt.xzzf.common.entity;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.constant.DictConstants;
import com.kdgcsoft.jt.xzzf.common.constant.SystemConstants;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import lombok.Data;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.*;


/**
 * 实体基类
 *
 * @author mapp
 * @date 2019-11-22
 */
@Data
public abstract class BaseEntity<T> extends BaseRowModel implements Serializable {

    /****
     *
     * @return
     */
    public abstract T getId();

    /****
     *
     * @param id
     */
    public abstract void setId(T id);

    /**
     * 创建人
     */
    @TableField(value = "CREATER", fill = FieldFill.INSERT)
    public String creater;

    /**
     * 创建时间
     */
    @TableField(value = "CREATE_TIME", fill = FieldFill.INSERT)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    public Date createTime;

    /**
     * 更新人
     */
    @TableField(value = "UPDATER", fill = FieldFill.INSERT_UPDATE)
    public String updater;

    /**
     * 更新时间
     */
    @TableField(value = "UPDATE_TIME", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    public Date updateTime;

    /**
     * 删除标志 00 未删除 01 已删除
     */
    @TableField(value = "DELETE_FLAG", fill = FieldFill.INSERT)
    public String deleteFlag;

    /**
     * 查询范围:01-本单位,02-下级单位,03-本单位及下级单位,99-全部
     */
    @TableField(exist = false)
    public String range = DictConstants.DICT_CODE_RANGE_99;

    /**
     * 附件信息(前台往后台传)
     */
    @TableField(exist = false)
    public String attachDetails;

    /**
     * 附件List信息(后台往前台传)
     */
    @TableField(exist = false)
    public List<AttachmentVo> attachList = new ArrayList<>();

    /***
     * 开始时间
     */
    @TableField(exist = false)
    private String startFilterTime;

    /***
     * 截止时间
     */
    @TableField(exist = false)
    private String endFilterTime;

    /***
     * 时间
     */
    @TableField(exist = false)
    private String[] filterTime;

    /*****
     * excel单元格样式
     */
    @TableField(exist = false)
    private Map<Integer, CellStyle> cellStyleMap = new HashMap<Integer, CellStyle>();

    /******
     * 当前页
     */
    @TableField(exist = false)
    private Long current = Long.parseLong(SystemConstants.PAGE_CUR_DEF_VALUE);

    /******
     * 分页大小
     */
    @TableField(exist = false)
    private Long size = Long.parseLong(SystemConstants.PAGE_SIZE_DEF_VALUE);

    public DateTime getStartTime() {
        if (BeanUtils.isNotEmpty(this.startFilterTime)) {
            return DateUtil.parse(this.startFilterTime + SystemConstants.START_TIME_SPLICING);
        } else if (BeanUtils.isNotEmpty(this.filterTime)) {
            if (BeanUtils.isNotEmpty(this.filterTime[0])) {
                return DateUtil.parse(this.filterTime[0] + SystemConstants.START_TIME_SPLICING);
            } else {
                return DateUtil.parse(this.filterTime + SystemConstants.START_TIME_SPLICING);
            }
        } else {
            return null;
        }
    }

    public DateTime getStartTime(String startTime) {
        if (BeanUtils.isNotEmpty(startTime)) {
            return DateUtil.parse(startTime + SystemConstants.START_TIME_SPLICING);
        } else {
            return null;
        }
    }

    public DateTime getEndTime() {
        if (BeanUtils.isNotEmpty(this.endFilterTime)) {
            return DateUtil.parse(this.endFilterTime + SystemConstants.END_TIME_SPLICING);
        } else if (BeanUtils.isNotEmpty(this.filterTime)) {
            if (BeanUtils.isNotEmpty(this.filterTime[this.filterTime.length - 1])) {
                return DateUtil.parse(this.filterTime[this.filterTime.length - 1] + SystemConstants.END_TIME_SPLICING);
            } else {
                return DateUtil.parse(this.filterTime + SystemConstants.END_TIME_SPLICING);
            }
        } else {
            return null;
        }
    }

    public DateTime getEndTime(String endTime) {
        if (BeanUtils.isNotEmpty(endTime)) {
            return DateUtil.parse(endTime + SystemConstants.START_TIME_SPLICING);
        } else {
            return null;
        }
    }
}
