package com.kdgcsoft.jt.xzzf.common.controller;

import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.exception.AppBusinessException;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

import java.util.List;

/**
 * 统一异常处理 加 参数校验
 *
 * @author mapp
 */
@RestControllerAdvice
public class ExceptionControllerAdvice {

    private static final Logger log = LoggerFactory.getLogger(ExceptionControllerAdvice.class);

    /**
     * 其他异常
     *
     * @param e
     * @return
     */
    @ExceptionHandler(value = Exception.class)
    public Result error(Exception e) {
        log.error("error", e);
        if (e instanceof BusinessException) {
            BusinessException busException = (BusinessException) e;
            return Result.fail(busException.getMessage());
        }else if (e instanceof MaxUploadSizeExceededException) {
            return Result.fail("附件已超出规定大小！");
        }else if (e instanceof AppBusinessException) {
            return Result.fail(e.getMessage());
        }
        return Result.fail("操作失败！");
    }

    /**
     * 参数校验异常
     *
     * @param e
     * @param result
     * @return
     */
    @ExceptionHandler(value = BindException.class)
    public Result bindError(BindException e, BindingResult result) {
        log.error("error", e);
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (BeanUtils.isNotEmpty(fieldErrors)) {
            StringBuilder sb = new StringBuilder();
            for (FieldError error : fieldErrors) {
                sb.append(error.getField()).append(":").append(error.getDefaultMessage());
            }
            return Result.fail(sb.toString());
        }
        return Result.fail();
    }
}
