package com.kdgcsoft.jt.xzzf.common.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.*;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.constant.CacheKeyConstants;
import com.kdgcsoft.jt.xzzf.common.constant.SystemConstants;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.jt.xzzf.common.util.ShiroUtil;
import com.kdgcsoft.jt.xzzf.common.util.SysUtils;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDept;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.*;
import com.kdgcsoft.jt.xzzf.dubbo.xtba.common.service.CommonService;
import com.kdgcsoft.jt.xzzf.dubbo.xzsp.common.service.XzspCommonService;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyDataVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service.ZfRyXxService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * @Description: 通用接口
 * @Author: zd
 * @Date: 2019/12/25
 */
@Log4j2
@RestController
@RequestMapping("/common")
public class CommonController {

    @Reference(check = false, lazy = true)
    private SysDicService sysDicService;

    @Reference(check = false, lazy = true)
    private SysOrgService sysOrgService;

    @Reference(check = false, lazy = true)
    private SysDeptService sysDeptService;

    @Reference(check = false, lazy = true)
    private SysMenuService sysMenuService;

    @Reference(check = false, lazy = true)
    private CommonService commonService;

    @Reference(check = false, lazy = true)
    private XzspCommonService xzspCommonService;

    @Reference(check = false, lazy = true)
    private SysXzqhService sysXzqhService;

    @Reference(check = false, lazy = true)
    private ZfRyXxService zfRyXxService;

    @Reference(check = false, lazy = true)
    private SysUserService sysUserService;

    @Reference(check = false, lazy = true)
    private SysSubSystemService sysSubSystemService;

    @Reference(check = false, lazy = true)
    private SysRoleService sysRoleService;

    @Reference(check = false, lazy = true)
    private SysUserRoleService sysUserRoleService;

    @Autowired
    private XzzfProperties xzzfProperties;

    @Autowired
    private RedisUtil redisUtil;

    /******
     * 获取当前用户信息
     * @return
     */
    @RequestMapping("/getUserInfo")
    public Result getUserInfo() {
        //获取用户特定的角色信息并返回用户信息
        SysUser userInfo = this.sysUserRoleService.getUserSpecRoleInfo(xzzfProperties.getSubSysKey(), SysUtils.getCurUser());
        return Result.success(userInfo);
    }

    /*****
     * 根据机构获取部门信息
     * @param orgId 机构id
     * @return
     */
    @RequestMapping("/getDeptByOrgId")
    public Result getDeptByOrgId(@RequestParam(value = "orgId") String orgId) {
        List<SysDept> list = this.sysDeptService.getEntityDataListByOrgId(orgId);
        return Result.success(list);
    }

    /******
     * 获取数据字典下拉框数据
     * @param dictCode 数据字典编码
     * @return
     */
    @RequestMapping("/getListByCode")
    public Result combobox(String dictCode) {
        List<ComboboxVo> list = this.sysDicService.queryEntityCombobox(dictCode);
        return Result.success(list);
    }

    /******
     * 获取数据字典下拉框数据
     * @param dictCode 数据字典编码
     * @return
     */
    @RequestMapping("/dictCombobox")
    public Result dictCombobox(String dictCode) {
        List<ComboboxVo> list = this.sysDicService.queryEntityCombobox(dictCode);
        return Result.success(list);
    }

    /*****
     * 根据字典编码和字典值，获取字典文字
     * @param dictCode  字典编码
     * @param dictValue 字典值
     * @return
     */
    @RequestMapping("/getDictText")
    public Result getTextByCodeAndValue(String dictCode, String dictValue) {
        String dictText = this.sysDicService.getDictText(dictCode, dictValue);
        return Result.success(dictText, "查询成功");
    }

    /******
     * 获取菜单树数据
     * @param entity 实体类信息
     * @return
     */
    @RequestMapping("/menuTree")
    public Result menuTree(SysMenu entity) {
        return Result.success(this.sysMenuService.queryMenuTreeDataList(entity));
    }

    /*****
     * 从当前登录用户所在的组织机构中获取组织机构树
     * @param orgId 组织机构id
     * @return
     */
    @RequestMapping("/orgTree")
    public Result orgTree(@RequestParam(value = "orgId", required = false) String orgId, String filter) {
        // 获取组织机构数据
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgTreeData(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeDataVos);
    }

    /*****
     * 从全部组织机构树中递归查询子集数据
     * @param orgId 组织机构id
     * @return
     */
    @RequestMapping("/allOrgTree")
    public Result allOrgTree(@RequestParam(value = "orgId", required = false) String orgId, String filter) {
        // 获取组织机构数据
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgTreeData(orgId, filter, SysOrg.ORG_ROOT_ID);
        return Result.success(treeDataVos);
    }

    /*****
     * 从当前登录用户所在的组织机构中获取组织机构树
     * @param orgId 组织机构id
     * @return
     */
    @RequestMapping("/orgParTree")
    public Result orgParTree(@RequestParam(value = "orgId", required = false) String orgId, String filter) {
        // 获取组织机构数据
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryOrgParTreeData(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeDataVos);
    }

    /*******
     * 获取跨单位组织机构树
     * @param orgId
     * @param filter
     * @return
     */
    @RequestMapping("/crossUnitOrgTree")
    public Result crossUnitOrgTree(@RequestParam(value = "orgId", required = false) String orgId, String filter) {
        // 获取组织机构数据
        List<TreeDataVo> treeDataVos = this.sysOrgService.queryCrossUnitOrgTreeData(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeDataVos);
    }

    /*****
     * 获取同级的组织机构树数据
     * @param orgId
     * @param filter
     * @return
     */
    @RequestMapping("/sameLevelOrgTree")
    public Result sameLevelTree(String orgId, String filter) {
        List<TreeDataVo> treeList = this.sysOrgService.querySameLevelOrgTree(orgId, filter, SysUtils.getCurUserOrgId());
        return Result.success(treeList);
    }

    /*****
     * 组织机构信息分页查询
     * @param current 当前页
     * @param size    分页条数
     * @param entity
     * @return
     */
    @RequestMapping("/orgPage")
    public Result pageData(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current, @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysOrg entity) {
        Page<SysOrg> page = this.sysOrgService.page(new Page<>(current, size), entity, SysUtils.getCurUserOrgId());
        return Result.success(page);
    }

    /*****
     * 组织机构信息列表查询
     * @param entity
     * @return
     */
    @RequestMapping("/orgList")
    public Result orgList(SysOrg entity) {
        return Result.success(this.sysOrgService.dataList(entity, SysUtils.getCurUserOrgId()));
    }

    /******
     * 获取组织机构下拉数据
     * @param filter 关键字
     * @param containFilters 数据中包含的关键字
     * @param xzqhId 行政区划Id
     * @return
     */
    @RequestMapping("/orgCombobox")
    public Result orgCombobox(String filter, String containFilters, String xzqhId) {
        return Result.success(this.sysOrgService.queryEntityInfoComboboxByContainFiltersAndXzqhId(filter, containFilters, xzqhId));
    }

    /*****
     * 查询用户菜单信息
     * @return
     */
    @RequestMapping("/queryUserMenu")
    public Result queryUserMenu() {
        HashMap<String, Object> map = new HashMap<>();
        //获取菜单权限信息
        if (BeanUtils.isNotEmpty(ShiroUtil.getLoginUser())) {
            map.put("menuInfo", ShiroUtil.getLoginUser().getMenuInfo());
        } else {
            map.put("menuInfo", this.sysMenuService.queryAuthMenuByUserIdAndSubSysId(SysUtils.getCurUser().getUserId(), xzzfProperties.getSubSysKey()));
        }
        //获取子系统信息
        map.put("sysInfo", this.sysSubSystemService.getEntityInfoById(xzzfProperties.getSubSysKey()));
        //获取用户特定的角色信息并返回用户信息
        SysUser curUser = this.sysUserRoleService.getUserSpecRoleInfo(xzzfProperties.getSubSysKey(), SysUtils.getCurUser());
        map.put("userInfo", curUser);
        return Result.success(map);
    }

    /******
     * 修改密码
     * @param entity
     * @return
     */
    @RequestMapping("/modifyPwd")
    public Result modifyPwd(SysUser entity) {
        this.sysUserService.modifyPwd(entity, SysUtils.getCurUser(), SysUtils.curUserIsSuperAdmin());
        redisUtil.set(CacheKeyConstants.PREFIX_USER + entity.getUserId(), JSON.toJSONString(sysUserService.getEntityInfoById(entity.getUserId())));
        return Result.msg("修改成功");
    }

    /*****
     * 行政区划树
     * @param xzqhId 行政区划树Id
     * @param xzqhdj 行政区划等级（1：省，2：市，3：县、区）
     * @param fanwei 范围：1：查询所有子节点(不传的话默认当前节点和下级节点)
     * @param filter 关键字过滤
     * @return
     */
    @RequestMapping("/xzqhTree")
    public Result getXzQhInfo(@RequestParam(value = "xzqhid", required = false) String xzqhId,
                              @RequestParam(value = "xzqhdj", required = false) String xzqhdj,
                              @RequestParam(value = "fanwei", required = false) String fanwei,
                              @RequestParam(value = "filter", required = false) String filter) {
        List<TreeDataVo> list = sysXzqhService.getXzQhTreeInfo(xzqhId, xzqhdj, fanwei, filter);
        return Result.success(list);
    }

    /*****
     * 获取行政区划树信息
     * @param xzqhbm 行政区划编码
     * @param xzqhLevels 过滤行政区划等级（1：省，2：市，3：县、区）
     * @return
     */
    @RequestMapping("/xzqhScopeTree")
    public Result xzqhScopeTree(@RequestParam(value = "xzqhbm", required = false) String xzqhbm, String xzqhLevels, String filter) {
        // 获取行政区划树数据
        List<TreeDataVo> treeDataVos = sysXzqhService.queryScopeRecXzqhTreeData(xzqhbm, xzqhLevels, filter);
        return Result.success(treeDataVos);
    }

    /*****
     * 子系统下拉框数据
     * @return
     */
    @RequestMapping("/subSysCombobox")
    public Result subSysCombobox(String filter) {
        return Result.success(this.sysSubSystemService.queryEntityInfoCombobox(filter, xzzfProperties.getSubSysKey()));
    }

    /*****
     * 子系统编码下拉框数据
     * @return
     */
    @RequestMapping("/subSysCodeCombobox")
    public Result subSysCodeCombobox(String filter) {
        return Result.success(this.sysSubSystemService.queryEntityInfoCodeCombobox(filter, xzzfProperties.getSubSysKey()));
    }

    /*****
     * 系统用户下拉框数据
     * @return
     */
    @RequestMapping("/sysUserCombobox")
    public Result sysUserCombobox(String filter) {
        return Result.success(this.sysUserService.queryEntityInfoCombobox(filter, SysUtils.getCurUserOrgId()));
    }

    /******
     * 根据执法证号查询执法人员信息
     * @param zfzh
     * @return
     */
    @RequestMapping("/queryZfryInfoByZfzh")
    public Result queryZfRyInfoByZfZh(@RequestParam(value = "zfzh") String zfzh) {
        ZfRyXxVO zfRyXxVO = zfRyXxService.queryZfRyInfoByZfZh(zfzh);
        return Result.success(zfRyXxVO);
    }

    /******
     * 获取用户信息
     * @param current
     * @param size
     * @param entity
     * @param showOrgChildUser 是否显示组织机构子集的用户信息
     * @return
     */
    @RequestMapping("/queryUserByOrgId")
    public Result queryUserByOrgId(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current, @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysUser entity, boolean showOrgChildUser) {
        return Result.success(this.sysUserService.pageDataByOrgId(new Page<>(current, size), entity, SysUtils.getCurUserOrgId(), showOrgChildUser));
    }

    /**
     * 分析研判系统数据对接接口---查询执法人员列表
     *
     * @param parameters 为 执法证号 组织机构名称  姓名 身份证件
     * @param orgId      组织机构ID
     * @return
     */
    @RequestMapping("/queryZfRyInfoList")
    public Result queryZfRyInfoList(
            @RequestParam(defaultValue = "1") long current,
            @RequestParam(defaultValue = "10") long size,
            @RequestParam(value = "parameters", required = false) String parameters,
            @RequestParam(value = "orgId", required = false) String orgId) {
        if (StrUtil.isEmpty(orgId)) {
            Result.fail(ResultCode.FAIL, "参数不能为空");
        }
        ZfRyDataVO zfRyDataVO = new ZfRyDataVO();
        zfRyDataVO.setParameters(parameters);
        zfRyDataVO.setOrgId(orgId);
        Page<ZfRyDataVO> list = zfRyXxService.queryZfRyInfoList(current, size, zfRyDataVO);
        if (ObjectUtil.isNotEmpty(list)) {
            return Result.success(list);
        } else {
            return Result.msg("暂无数据");
        }

    }

    /**
     * 分析研判系统数据对接接口 --查询执法人员详细信息的接口
     *
     * @param zfryxxId 执法证号
     * @return
     */
    @RequestMapping("/queryZfryByZfRyXxId")
    public Result queryZfryByZfRyXxId(@RequestParam(value = "id", required = false) String zfryxxId) {
        if (StrUtil.isEmpty(zfryxxId)) {
            Result.fail(ResultCode.FAIL, "参数不能为空");
        }
        ZfRyDataVO zfRyDataVO = zfRyXxService.queryZfryByZfRyXxId(zfryxxId);
        if (ObjectUtil.isEmpty(zfRyDataVO)) {
            return Result.msg("暂无数据");
        }
        return Result.success(zfRyDataVO);
    }

    /**
     * 分析研判系统数据对接接口---根据组织机构Id查询人员信息
     *
     * @param orgId
     * @return
     */
    @RequestMapping("/queryZfRyInfoByOrgId")
    public Result queryZfRyInfoByOrgId(@RequestParam(value = "orgId", required = false) String orgId) {
        if (StrUtil.isEmpty(orgId)) {
            Result.fail(ResultCode.FAIL, "参数不能为空");
        }
        List<ZfRyXxVO> zfRyXxVOS = zfRyXxService.queryZfRyInfoByOrgId(orgId);
        return Result.success(zfRyXxVOS);
    }

    /*****
     * 报表统计查询行政区划树
     * @param xzqhId 行政区划树Id
     * @param xzqhdj 行政区划等级（1：省，2：市，3：县、区）
     * @param fanwei 范围：1：查询所有子节点(不传的话默认当前节点和下级节点)
     * @param filter 关键字过滤
     * @return
     */
    @RequestMapping("/xzqhDtree")
    public DTreeResponseVo xzqhDtree(@RequestParam(value = "xzqhid", required = false) String xzqhId,
                                     @RequestParam(value = "xzqhdj", required = false) String xzqhdj,
                                     @RequestParam(value = "fanwei", required = false) String fanwei,
                                     @RequestParam(value = "filter", required = false) String filter) {
        List<TreeDataVo> list = sysXzqhService.getXzQhTreeInfo(xzqhId, xzqhdj, fanwei, filter);
        List<ReportDtreeVo> list1 = new ArrayList<>();
        for (TreeDataVo vo : list) {
            ReportDtreeVo reportDtreeVo = new ReportDtreeVo();
            reportDtreeVo.setId(vo.getNodeId());
            reportDtreeVo.setTitle(vo.getNodeName());
            reportDtreeVo.setParentId(vo.getNodePid());
            list1.add(reportDtreeVo);
        }
        DTreeResponseVo dTreeResponse = new DTreeResponseVo();
        StatusVo status = new StatusVo();
        dTreeResponse.setStatus(status);
        dTreeResponse.setData(list1);
        dTreeResponse.setMsg("操作成功");
        return dTreeResponse;
    }

    /*****
     * 报表统计查询执行单位树
     * @param orgId 组织机构树Id
     * @param filter 关键字过滤
     * @return
     */
    @RequestMapping("/getlOrgTree")
    public DTreeResponseVo getOrgTree(String orgId, String filter) {
        List<TreeDataVo> treeDataVos = sysOrgService.queryOrgTreeData(orgId, filter, SysOrg.ORG_ROOT_ID);
        List<ReportDtreeVo> list1 = new ArrayList<>();
        for (TreeDataVo vo : treeDataVos) {
            ReportDtreeVo reportDtreeVo = new ReportDtreeVo();
            reportDtreeVo.setId(vo.getNodeId());
            reportDtreeVo.setTitle(vo.getNodeName());
            reportDtreeVo.setParentId(vo.getNodePid());
            list1.add(reportDtreeVo);
        }
        DTreeResponseVo dTreeResponse = new DTreeResponseVo();
        StatusVo status = new StatusVo();
        dTreeResponse.setStatus(status);
        dTreeResponse.setData(list1);
        dTreeResponse.setMsg("操作成功");
        return dTreeResponse;
    }

    /**
     * 获取服务器当前时间
     *
     * @return
     */
    @RequestMapping("getCurrentTime")
    public Result getCurrentTime() {
        return Result.success(new Date());
    }
}
