package com.kdgcsoft.jt.xzzf.common.controller;


import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.kdgcsoft.jt.xzzf.common.entity.LoginUser;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.ShiroUtil;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 控制器基础类
 *
 * @author mapp
 */
public class BaseController {

    /**
     * 获取当前登陆用户信息
     *
     * @return
     */
    protected LoginUser getUser() {
        return ShiroUtil.getLoginUser();
    }

    /**
     * 操作结果
     *
     * @param flag
     * @param <T>
     * @return
     */
    protected <T> Result result(boolean flag) {
        return Result.result(false);
    }

    /**
     * 请求成功返回体
     *
     * @param obj
     * @param <T>
     * @return
     */
    protected <T> Result success(T obj) {
        return Result.success(obj, "保存成功");
    }

    /**
     * 请求失败返回体
     *
     * @param
     * @return
     */
    protected Result fail() {
        return Result.fail();
    }

    /**
     * 请求失败返回体
     *
     * @param msg
     * @return
     */
    protected Result fail(String msg) {
        return Result.fail(msg);
    }

    /**
     * 请求失败返回体
     *
     * @param code
     * @return
     */
    protected Result fail(ResultCode code) {
        return Result.fail(code);
    }

    /****
     * 通用导出
     * @param response
     * @param exportRows
     * @param fileName
     */
    protected void excelWriter(HttpServletResponse response, List<Map<String, Object>> exportRows, String fileName) throws RuntimeException {
        // 通过工具类创建writer
        ExcelWriter writer = ExcelUtil.getWriter();
        try {
            writer.setColumnWidth(-1, 20);
            writer.setRowHeight(-1, 20);
            // 列设置为自动宽度
            writer.autoSizeColumnAll();;
            writer.write(exportRows);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            //不设置此语句，则successCallback回调函数失效
            response.setHeader("Set-Cookie", "fileDownload=true; path=/");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
            writer.flush(response.getOutputStream());
        } catch (IOException e) {
            throw new RuntimeException("导出失败");
        } finally {
            // 关闭流
            writer.close();
        }
    }
}
