package com.kdgcsoft.jt.xzzf.common.constant;

import cn.hutool.core.util.StrUtil;

/****
 * @className SystemConstants
 * @author chris
 * @description 系统常量
 * @version 1.0
 * @date 2019-12-24 17:32
 */
public class SystemConstants {

    /****
     * 开始时间拼接
     */
    public static final String START_TIME_SPLICING = StrUtil.SPACE + "00:00:00";

    /****
     * 截止时间拼接
     */
    public static final String END_TIME_SPLICING = StrUtil.SPACE + "23:59:59";

    /*****
     * 数据分页:默认当前页的值为1
     */
    public static final String PAGE_CUR_DEF_VALUE = "1";

    /*****
     * 数据分页:默认初始分页值为10
     */
    public static final String PAGE_SIZE_DEF_VALUE = "10";

    /**
     * app token参数名
     */
    public static final String APP_TOKEN = "token";

    /**
     * 行政执法app请求后台统一路径
     */
    public static final String APP_REQUEST_URL_PREFIX = "/xzzapp";

    /**
     * 菜单布局
     */
    public static final String MENU_LAYOUT = "Layout";

    /****
     * 布尔值:
     * true-真,
     * false-假
     */
    public static final String BOOLEAN_VALUE_TRUE = "true";
    public static final String BOOLEAN_VALUE_FALSE = "false";

    /****
     * 类型值:
     * PC-电脑端,
     * APP-移动端
     */
    public static final String CATEGORY_VALUE_PC = "PC";
    public static final String CATEGORY_VALUE_APP = "APP";

    /*****
     * 拼接字符:
     * UNDERLINE:_
     */
    public static final String JOINT_CHAR_UNDERLINE = StrUtil.UNDERLINE;

    /******
     * 递归查询方式
     * 01-向上递归
     * 02-向下递归
     */
    public static final String QUERY_RECURSION_TYPE_01 = "01";
    public static final String QUERY_RECURSION_TYPE_02 = "02";

    /*****
     * 子系统主键
     * SUB_SYS_KEY_JCGL:基础管理系统
     * SUB_SYS_KEY_XTBA:协同办案系统
     * SUB_SYS_KEY_ZFRY:执法人员系统
     * SUB_SYS_KEY_ZBGL:装备管理系统
     */
    public static final String SUB_SYS_KEY_JCGL = "BA034C289D9449E68B5B3411957A40DF";
    public static final String SUB_SYS_KEY_XTBA = "41C6B35A51AF406C9BCED5B0365C74E7";
    public static final String SUB_SYS_KEY_ZFRY = "407AB711609F403B896996D3B7F271CC";
    public static final String SUB_SYS_KEY_ZBGL = "8356790510604B8E8E9C64758ED9E7A5";
}
