package com.kdgcsoft.jt.xzzf.common.constant;

/****
 * @className DictConstants
 * @author chris
 * @description 数据字典Code编码常量
 * @version 1.0
 * @date 2019-12-24 11:53
 */
public class DictConstants {

    /***
     * 性别:SEX
     * 男：1，
     * 女：2
     */
    public static final String DICT_CODE_SEX = "SEX";
    public static final String DICT_CODE_SEX_1 = "1";
    public static final String DICT_CODE_SEX_2 = "2";

    /***
     * 是否启用:SFQY
     * 启用：1；
     * 禁用：0
     */
    public static final String DICT_CODE_STATUS = "SFQY";
    public static final String DICT_CODE_STATUS_1 = "1";
    public static final String DICT_CODE_STATUS_0 = "0";
    public static final String DICT_CODE_STATUS_01 = "01";
    public static final String DICT_CODE_STATUS_02 = "02";

    /***
     * 是否:YES_NO
     * 是：1；
     * 否：0
     */
    public static final String DICT_CODE_YES_NO = "YES_NO";
    public static final String DICT_CODE_YES_NO_1 = "1";
    public static final String DICT_CODE_YES_NO_0 = "0";
    public static final String DICT_CODE_YES_NO_01 = "01";
    public static final String DICT_CODE_YES_NO_02 = "02";

    /***
     * 查询范围:JCGL_RANGE
     * 01-本级
     * 02-下级
     * 03-本级及下级
     * 99-全部
     */
    public static final String DICT_CODE_RANGE = "JCGL_RANGE";
    public static final String DICT_CODE_RANGE_01 = "01";
    public static final String DICT_CODE_RANGE_02 = "02";
    public static final String DICT_CODE_RANGE_03 = "03";
    public static final String DICT_CODE_RANGE_99 = "99";

    /***
     * 行政区划等级:JCGL_XZQH_LEVEL
     * 1-省级
     * 2-市级
     * 3-区县级
     */
    public static final String DICT_CODE_XZQH_LEVEL = "JCGL_XZQH_LEVEL";
    public static final String DICT_CODE_XZQH_LEVEL_1 = "1";
    public static final String DICT_CODE_XZQH_LEVEL_2 = "2";
    public static final String DICT_CODE_XZQH_LEVEL_3 = "3";

    /*****
     *系统失败次数阈值
     * SYS_FAILURE_NUM:系統失敗次數
     * SYS_FAILURE_NUM_LOGIN:登录
     * SYS_FAILURE_NUM_SIGN_SEAL:签章盖章
     * SYS_FAILURE_NUM_SIGN_PREVIEW:签章预览
     */
    public static final String DICT_CODE_SYS_FAILURE_NUM = "SYS_FAILURE_NUM";
    public static final String DICT_CODE_SYS_FAILURE_NUM_LOGIN = "SYS_FAILURE_NUM_LOGIN";
    public static final String DICT_CODE_SYS_FAILURE_NUM_SIGN_SEAL = "SYS_FAILURE_NUM_SIGN_SEAL";
    public static final String DICT_CODE_SYS_FAILURE_NUM_SIGN_PREVIEW = "SYS_FAILURE_NUM_SIGN_PREVIEW";
}
