package com.kdgcsoft.jt.xzzf.common.config.shiro;

import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import org.apache.shiro.web.filter.authc.UserFilter;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * 用户拦截器 未认证的请求都返回json数据 前后端分离使用
 *
 * @author mpp
 */
public class XzzfUserFilter extends UserFilter {

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (response instanceof HttpServletResponse) {
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json; charset=utf-8");
            PrintWriter writer = response.getWriter();
            Result fail = Result.fail(ResultCode.FORBID, "因长时间未操作，您已强制下线，请重新登录系统。");
            fail.setLoginSuccess("0");
            writer.write(JSON.toJSONString(fail));
            return false;
        }
       return super.onAccessDenied(request, response);
    }
}
