package com.kdgcsoft.jt.xzzf.common.config.shiro;

import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.online.OnLineUserService;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.SpringContextHolder;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/**
 * cas Filter
 *
 * @author mpp
 */
public class XzzfCasFilter extends CasFilter {

    @Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        Session session = subject.getSession();
        CasToken casToken = (CasToken) token;
        OnLineUserService onLineUserService = SpringContextHolder.getBean(OnLineUserService.class);
        // 设置session和tgt关联
        onLineUserService.setSessionTgt(String.valueOf(session.getId()), String.valueOf(casToken.getCredentials()));
        // 直接跳转到配置的首页
        WebUtils.issueRedirect(request, response, getSuccessUrl(), (Map)null, false);
        return false;
    }

    @Override
    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
//        if (response instanceof HttpServletResponse) {
//            response.setCharacterEncoding("utf-8");
//            response.setContentType("application/json; charset=utf-8");
//            try (PrintWriter writer = response.getWriter()) {
//                Result fail = Result.fail(ResultCode.FORBID, "因长时间未操作，您已强制下线，请重新登录系统！");
//                fail.setLoginSuccess("0");
//                writer.write(JSON.toJSONString(fail));
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//            return false;
//        }
        return super.onLoginFailure(token, ae, request, response);
    }
}
