package com.kdgcsoft.jt.xzzf.common.config.shiro;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.constant.OnLineConstant;
import com.kdgcsoft.jt.xzzf.common.entity.OnLineUser;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.online.OnLineUserService;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.SpringContextHolder;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.UserFilter;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * 账号只能在一处登陆拦截器, 前后端不分离使用
 *
 * @author mpp
 */
public class UniqueUserFilter extends UserFilter {

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginRequest(request, response)) {
            return true;
        } else {
            Subject subject = this.getSubject(request, response);
            return subject.getPrincipal() != null && checkSessionTgt((HttpServletRequest) request, (HttpServletResponse) response);
        }
    }

    /**
     * 账号只能在一处登陆 校验  sessionId + userName : CASTGT
     *
     * @param request
     * @param response
     * @return
     */
    private boolean checkSessionTgt(HttpServletRequest request, HttpServletResponse response) {
        // 拦截ajax请求，可以弹出掉线提醒
        if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
            OnLineUserService onLineUserService = SpringContextHolder.getBean(OnLineUserService.class);
            return onLineUserService.checkSessionTgt(request.getSession().getId());
        }
        return true;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletResponse httpServletResponse = (HttpServletResponse) response;
        // getSubject(request, response).getPrincipal() != null 说明  checkSessionTgt 返回的必然是false
        if (getSubject(request, response).getPrincipal() != null) {

            OnLineUserService onLineUserService = SpringContextHolder.getBean(OnLineUserService.class);
            OnLineUser onLineUser = onLineUserService.getCurrentOnlineUser();
            Result fail = Result.fail(ResultCode.OFFLINE, "您的账号已在其他地方登陆，您已掉线！");
            if (StrUtil.equals(OnLineConstant.OFFLINE, onLineUser.getStatus())) {
                fail.setMessage("您已被强制下线！");
            }
            httpServletResponse.setCharacterEncoding("utf-8");
            httpServletResponse.setContentType("application/json; charset=utf-8");
            httpServletResponse.setStatus(300);
            try (PrintWriter writer = httpServletResponse.getWriter()) {
                fail.setLoginSuccess("2");
                writer.write(JSON.toJSONString(fail));
            } catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return super.onAccessDenied(request, response);
    }
}
