//package com.kdgcsoft.jt.xzzf.common.config.shiro;
//
//import cn.hutool.core.collection.CollUtil;
//import org.apache.shiro.cache.Cache;
//import org.apache.shiro.cache.CacheException;
//import org.springframework.data.redis.core.RedisTemplate;
//
//import java.util.ArrayList;
//import java.util.Collection;
//import java.util.Collections;
//import java.util.Set;
//
//
///**
// * 扩展shir cache
// *
// */
//public class RedisCache<K, V> implements Cache<K, V> {
//
//    public static final String SHIRO_PRE_KEY = "shiro_pre_key_";
//    private String name;
//    private RedisTemplate redisTemplate;
//
//    public RedisCache(String name, RedisTemplate redisTemplate) {
//        this.name = name;
//        this.redisTemplate = redisTemplate;
//    }
//
//    @Override
//    public V get(K k) throws CacheException {
//        return (V) redisTemplate.opsForValue().get(k);
//    }
//
//    @Override
//    public V put(K k, V v) throws CacheException {
//        redisTemplate.opsForValue().set(k, v);
//        return v;
//    }
//
//    @Override
//    public V remove(K k) throws CacheException {
//        V v = get(k);
//        redisTemplate.delete(k);
//        return v;
//    }
//
//    @Override
//    public void clear() throws CacheException {
//        redisTemplate.delete(keys());
//    }
//
//    @Override
//    public int size() {
//        return 0;
//    }
//
//    @Override
//    public Set<K> keys() {
//        Set keys = redisTemplate.keys(SHIRO_PRE_KEY + "*");
//        return !CollUtil.isEmpty(keys) ? Collections.unmodifiableSet(keys) : Collections.emptySet();
//    }
//
//    @Override
//    public Collection<V> values() {
//        Collection<V> collection = new ArrayList<>();
//        Set<K> keys = keys();
//        for (K key : keys) {
//            collection.add(get(key));
//        }
//        return Collections.unmodifiableCollection(collection);
//    }
//}
