package com.kdgcsoft.jt.xzzf.common.config.interceptor;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.constant.CacheKeyConstants;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.jt.xzzf.common.util.ShiroUtil;
import com.kdgcsoft.jt.xzzf.common.util.SysUtils;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroKit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class UniqueUserInterceptor implements HandlerInterceptor {

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String clientTgt = redisUtil.get("session" + request.getSession().getId() + "_" + ShiroKit.getUser().getUserName());
        String casTgt = redisUtil.get(CacheKeyConstants.PREFIX_WEB_TOKEN + ShiroKit.getUser().getUserName());
        if (!StrUtil.equals(clientTgt, casTgt)) {
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json; charset=utf-8");
            try (PrintWriter writer = response.getWriter()) {
                Result fail = Result.fail(ResultCode.OFFLINE, "您的账号已在其他地方登陆，您已掉线！");
                fail.setLoginSuccess("2");
                writer.write(JSON.toJSONString(fail));
            } catch (IOException e) {
                e.printStackTrace();
            }
            response.setStatus(300);
            return false;
        }
        return true;
    }
}
