package com.kdgcsoft.jt.xzzf.common.config.interceptor;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.config.annotation.Reference;
import com.kdgcsoft.jt.xzzf.common.component.AuthMenuVo;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.jt.xzzf.common.util.MenuTreeHelper;
import com.kdgcsoft.jt.xzzf.common.util.SysUtils;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.service.SysMenuService;
import com.kdgcsoft.scrdc.frame.webframe.core.model.UiTreeNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 不允许访问框架后台
 *
 * @author mapp
 */
public class IndexInterceptor implements HandlerInterceptor {

    @Reference(check = false, lazy = true)
    private SysMenuService sysMenuService;

    @Autowired
    private XzzfProperties xzzfProperties;

    /******
     *
     * @param request
     * @param response
     * @param handler
     * @return
     * @throws Exception
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String path = request.getServletPath();
        if (xzzfProperties.isFrontEnable() && StrUtil.SLASH.equals(path)) {
            return false;
        }
        return true;
    }

    /******
     *
     * @param request
     * @param response
     * @param handler
     * @param modelAndView
     * @throws Exception
     */
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String servletPath = request.getServletPath();
        if (!xzzfProperties.isFrontEnable() && StrUtil.SLASH.equals(servletPath)) {
            // 根目录， 重新查询菜单，替换modeAndView里的菜单信息
            List<AuthMenuVo> sysMenus = sysMenuService.queryAuthMenuByUserIdAndSubSysId(SysUtils.getCurUser().getUserId(), xzzfProperties.getSubSysKey());
            List<UiTreeNode> uiTreeNodes = MenuTreeHelper.buildFullMenuTree(sysMenus);
            modelAndView.addObject("userMenus", uiTreeNodes);
        }
    }
}
