package com.kdgcsoft.jt.xzzf.common.config.interceptor;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.annotation.Submit;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;

/**
 * 表单重复提交拦截器
 *
 *
 * @author mapp
 * @date 2019-8-15
 */
public class FormSubmitInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;
            Submit submit = method.getMethodAnnotation(Submit.class);
            if (submit == null) {
                return true;
            }
            // 校验表单数据
            Map<String, String[]> parameterMap = request.getParameterMap();
            String res = SecureUtil.md5(parameterMapToString(parameterMap));

            HttpSession session = request.getSession();
            String token = SecureUtil.md5(session.getId());
            String attribute = (String) session.getAttribute(token);
            if (attribute != null && attribute.equals(res)) {
                response.setCharacterEncoding("utf-8");
                response.setContentType("application/json; charset=utf-8");
                PrintWriter writer = response.getWriter();
                writer.write(JSON.toJSONString(Result.result(true)));
                return false;
            }
            session.setAttribute(token, res);
        }
        return true;
    }

    private String parameterMapToString(Map<String, String[]> map) {
        if (map == null) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        Set<Map.Entry<String, String[]>> entrySet = map.entrySet();

        for (Map.Entry<String, String[]> next : entrySet) {
            String[] valueArr = next.getValue();
            for (String value : valueArr) {
                res.append(value);
            }
        }

        return res.toString();
    }
}
