package com.kdgcsoft.jt.xzzf.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;


/**
 * 系统属性类
 *
 * @author mapp
 * @date 2019-12-5
 */
@Data
@Component
@ConfigurationProperties(prefix = "jt.xzzf")
public class XzzfProperties {

    /**
     * 是否记录日志
     */
    private boolean logEnable;

    /**
     * ftp地址
     */
    private String ftpHost;

    /**
     * ftp端口号
     */
    private int ftpPort;

    /**
     * ftp路径
     */
    private String ftpPath;

    /**
     * ftp用户名
     */
    private String ftpUser;

    /**
     * ftp密码
     */
    private String ftpPwd;

    /****
     * 所属子系统
     */
    private String subSysKey;

    /****
     * 系统所属模块
     */
    private String modelCode;

    /****
     * 电子签章接口地址
     */
    private String signUrl;

    /**
     * 是否前后端分离
     */
    private boolean frontEnable = true;

    /**
     * 单用户登录限制
     */
    private boolean uniqueUser = true;

    /**
     * 模板文件存放方式:true-服务器独立文件夹,false-项目自身的resources目录下
     */
    private boolean tempFileMode = false;

    /**
     * 临时文件存放目录
     */
    private String tempFilePath = "tmp";
}
