package com.kdgcsoft.jt.xzzf.common.config;

import com.kdgcsoft.jt.xzzf.common.config.interceptor.FormSubmitInterceptor;
import com.kdgcsoft.jt.xzzf.common.config.interceptor.IndexInterceptor;
import com.kdgcsoft.jt.xzzf.common.config.interceptor.UniqueUserInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 *
 * 公共配置
 *
 * @author chris
 */
@Configuration
public class CommonInterceptorConfig implements WebMvcConfigurer {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.submitInterceptor()).excludePathPatterns("/static/**");
        registry.addInterceptor(this.indexInterceptor()).excludePathPatterns("/static/**");
//        registry.addInterceptor(this.uniqueUserInterceptor()).excludePathPatterns("/static/**");
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**").addResourceLocations("file:./login/");
        registry.addResourceHandler("/icon/**").addResourceLocations("classpath:/icon/");
    }

    @Bean
    public IndexInterceptor indexInterceptor() {
        return new IndexInterceptor();
    }

    @Bean
    public FormSubmitInterceptor submitInterceptor() {
        return new FormSubmitInterceptor();
    }

    @Bean
    public UniqueUserInterceptor uniqueUserInterceptor() {
        return new UniqueUserInterceptor();
    }
}
