package com.kdgcsoft.jt.xzzf.common.config;

import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.jt.xzzf.common.config.shiro.CasShiroRealm;
import com.kdgcsoft.jt.xzzf.common.config.shiro.XzzfCasFilter;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Component;

import javax.servlet.Filter;
import java.util.Map;

/**
 * common 配置
 *
 * @author mpp
 */
@Component
@ComponentScan("com.kdgcsoft.jt.xzzf.common")
public class CommonConfig implements FrameExtConfig {

    @Autowired
    private ShiroCasProperties shiroCasProperties;

    @Autowired
    private XzzfProperties xzzfProperties;

    @Override
    public String modelCode() {
        if (BeanUtils.isNotEmpty(xzzfProperties.getModelCode())) {
            return xzzfProperties.getModelCode();
        } else {
            return "common";
        }
    }

    /**
     * cas-shiro
     *
     * @return
     */
    @Override
    public Class shiroRealm() {
        return shiroCasProperties.isCasEnable() ? CasShiroRealm.class : null;
    }

    @Override
    public Map<String, String> shiroFilterChain() {
        Map<String, String> map = MapUtil.newHashMap(true);
        map.put("/toLogin", "anon");
        map.put("/login.html", "anon");
        map.put("/css/**", "anon");
        map.put("/images/**", "anon");
        map.put("/file/**", "anon");
        map.put("/fileEditor/**", "anon");
        //执法人员上传课件附件
        map.put("/zfryFile/**","anon");
        map.put("/druid/**","anon");
        return map;
    }
}
