package com.kdgcsoft.jt.xzzf.common.component;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/****
 * @className TreeDataVo
 * @author chris
 * @description 树数据实体类
 * @version 1.0
 * @date 2020-01-07 09:47
 */
@Data
public class TreeDataVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /*****
     * 节点主键Id
     */
    private String nodeId;
    /*****
     * 节点名称
     */
    private String nodeName;
    /*****
     * 节点父级主键Id
     */
    private String nodePid;
    /*****
     * 节点父级名称
     */
    private String nodeParName;
    /*****
     * 节点类型
     */
    private String nodeType;
    /*****
     * 节点类别
     */
    private String nodeCategory;
    /*****
     * 根节点Id
     */
    private String rootNodeId;
    /*****
     * 根节点名称
     */
    private String rootNodeName;
    /*****
     * 节点等级
     */
    private String nodeLevel;
    /*****
     * 是否选中
     */
    private boolean nodeSelected = false;
    /*****
     * 是否禁用
     */
    private boolean nodeDisabled = false;
    /*****
     * 节点状态
     */
    private String nodeStatus;
    /*******
     * 节点排序
     */
    private Integer nodeSort;
    /*******
     * 节点编码
     */
    private String nodeCode;
    /*******
     * 节点图标
     */
    private String nodeIcon;
    /*****
     * 节点的子集
     */
    private List<TreeDataVo> children;
}
