package com.kdgcsoft.jt.xzzf.common.component;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/****
 * @className AuthMenuVo
 * @author chris
 * @description 权限菜单实体类
 * @version 1.0
 * @date 2020-05-11 13:27
 */
@Data
public class AuthMenuVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 菜单ID 主键字段
     */
    private String menuId;

    /**
     * 父菜单ID
     */
    private String menuPid;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 菜单编码
     */
    private String menuCode;

    /**
     * 页面对应的前台页面地址
     */
    private String menuPath;

    /**
     * 菜单URL
     */
    private String menuRedirect;

    /**
     * 类型 0：菜单  1：按钮
     */
    private String menuType;

    /**
     * 图标
     */
    private String menuIcon;

    /**
     * 菜单显示
     */
    private String hidden;

    /**
     * 顺序
     */
    private Integer menuOrder;

    /**
     * 页签编码
     */
    private String tabCode;

    /**
     * 页签是否需要缓存;是(1):页签只在首次加载时刷新;否(0):每次进入此页签都会刷新当前页签信息
     */
    private String tabAttr;

    /**
     * 按钮类型:1-工具栏按钮,2-列操作栏按钮
     */
    private String buttonType;

    /**
     * 列操作按钮
     */
    private List<String> colButtons = new ArrayList<>();

    /**
     * 工具栏按钮
     */
    private List<String> toolButtons = new ArrayList<>();

}
