package com.kdgcsoft.jt.xzzf.common.component;

import lombok.Data;

import java.io.Serializable;

/****
 * @className AttachmentVo
 * @author chris
 * @description 附件实体类
 * @version 1.0
 * @date 2020-04-02 11:39
 */
@Data
public class AttachmentVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /****
     * 附件类别
     * 01:通用类别
     * 02:照片信息
     * 03:档案信息
     */
    public static final String ATTACHMENT_CATEGORY_01 = "01";
    public static final String ATTACHMENT_CATEGORY_02 = "02";
    public static final String ATTACHMENT_CATEGORY_03 = "03";

    /*******
     * 附件Id
     */
    private String id;

    /****
     * 附件原始名称
     */
    private String oldFileName;

    /******
     * 附件新名称
     */
    private String newFileName;

    /******
     * 附件存储的公共路径
     */
    private String filePubPath;

    /******
     * 附件存储的路径
     */
    private String filePath;

    /******
     * 附件类型
     */
    private String fileType;

    /******
     * 附件类别
     */
    private String fileCategory = AttachmentVo.ATTACHMENT_CATEGORY_01;

    /*****
     * 文件后缀名
     */
    private String fileSuffix;
}
