package com.kdgcsoft.jt.xzzf.common.component;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/****
 * @className AppMenuVo
 * @author chris
 * @description App菜单实体类
 * @version 1.0
 * @date 2020-04-29 22:39
 */
@Data
public class AppMenuVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /******
     * app菜单Id
     */
    private String appMenuId;

    /******
     * app菜单名称
     */
    private String appMenuName;

    /******
     * app菜单编码
     */
    private String appMenuCode;

    /*****
     * app菜单地址
     */
    private String appMenuPath;

    /*****
     * app菜单是否显示
     */
    private String appMenuShow;

    /*****
     * app菜单显示的图标名称
     */
    private String appMenuIconName;

    /*****
     * app菜单显示顺序
     */
    private String appMenuSort;

    /******
     * app父级菜单Id
     */
    private String appMenuParId;

    /******
     * app父级菜单名称
     */
    private String appMenuParName;

    /******
     * app父级菜单编码
     */
    private String appMenuParCode;

    /*****
     * app菜单所属子系统编码
     */
    private String subSysCode;

    /*****
     * app菜单所属子系统
     */
    private String subSysName;

    /******
     * 工具栏按钮
     */
    private List<AppBtnVo> toolbarBtn;

    /******
     * 操作栏按钮
     */
    private List<AppBtnVo> operateBtn;
}
