package com.kdgcsoft.jt.xzzf.common.cache;


import cn.hutool.core.util.ClassUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.constant.CacheKeyConstants;
import com.kdgcsoft.jt.xzzf.common.util.BeanUtils;
import com.kdgcsoft.jt.xzzf.common.util.RedisUtil;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysDic;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.lang.reflect.Modifier;
import java.util.List;

/*******
 * 缓存获取工具类
 *
 * @author mapp
 */
@Slf4j
@Component
public class CacheUtil {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    ConfigurableApplicationContext configurableContext;

    /*******
     * 获取字典名称
     * @param dicCode  字典编码
     * @param dicValue 字典值
     * @return
     */
    public String getDicText(String dicCode, String dicValue) {
        SysDic dbEntity = getDic(dicCode, dicValue);
        if (BeanUtils.isEmpty(dbEntity)) {
            return "";
        }
        return dbEntity.getDicText();
    }

    /*******
     * 获取字典值
     * @param dicCode 字典编码
     * @param dicText 字典名称
     * @return
     */
    public String getDicValue(String dicCode, String dicText) {
        SysDic dbEntity = getDicByCodeAndText(dicCode, dicText);
        if (BeanUtils.isEmpty(dbEntity)) {
            return "";
        }
        return dbEntity.getDicValue();
    }

    /******
     * 获取字典
     * @param dicCode  字典编码
     * @param dicValue 字典值
     * @return
     */
    public SysDic getDic(String dicCode, String dicValue) {
        if (BeanUtils.isEmpty(dicValue) || BeanUtils.isEmpty(dicCode)) {
            return null;
        }
        return JSON.parseObject(redisUtil.get(CacheKeyConstants.PREFIX_DICT + dicCode + "_" + dicValue), SysDic.class);
    }

    /*******
     * 获取字典
     * @param dicCode 字典编码
     * @param dicText 字典名称
     * @return
     */
    public SysDic getDicByCodeAndText(String dicCode, String dicText) {
        if (BeanUtils.isEmpty(dicText) || BeanUtils.isEmpty(dicCode)) {
            return null;
        }
        return JSON.parseObject(redisUtil.get(CacheKeyConstants.PREFIX_DICT + dicCode + "_" + dicText), SysDic.class);
    }

    /******
     * 根据字典编码获取字典
     * @param dicCode
     * @return
     */
    public List<SysDic> getDicList(String dicCode) {
        return JSON.parseArray(redisUtil.get(CacheKeyConstants.PREFIX_DICT_TYPE + dicCode), SysDic.class);
    }

    /******
     * 根据字典编码获取字典下拉框
     * @param dicCode
     * @return
     */
    public List<ComboboxVo> getDicComboxList(String dicCode) {
        return JSON.parseArray(redisUtil.get(CacheKeyConstants.PREFIX_DICT_COMBOX_TYPE + dicCode), ComboboxVo.class);
    }

    /******
     * 根据字典编码获取字典下拉框
     * @param dicCode
     * @return
     */
    public List<ComboboxVo> getDicComboboxList(String dicCode) {
        return JSON.parseArray(redisUtil.get(CacheKeyConstants.PREFIX_DICT_COMBOBOX_TYPE + dicCode), ComboboxVo.class);
    }
    /******
     * 获取组织机构
     * @return
     */
    public SysOrg getOrg(String orgId) {
        return JSON.parseObject(redisUtil.get(CacheKeyConstants.PREFIX_ORG + orgId), SysOrg.class);
    }

    /*****
     * 获取用户
     * @param userId
     * @return
     */
    public SysUser getUser(String userId) {
        return JSON.parseObject(redisUtil.get(CacheKeyConstants.PREFIX_USER + userId), SysUser.class);
    }

    /*****
     * 根据用户id获取app clientId
     * @param userId
     * @return
     */
    public String getAppClientId(String userId) {
        return redisUtil.get(CacheKeyConstants.PREFIX_CLIENTID + userId);
    }

    /******
     * 清除缓存内的用户登录失败次数
     * @param userAct 用户账号
     */
    public void clearUserFailureNum(String userAct) {
        this.redisUtil.delete(CacheKeyConstants.PREFIX_LOGIN_FAIL_NUM + userAct);
    }

    /******
     * 初始化缓存
     */
    @PostConstruct
    public void initCache() {
        for (Class clazz : ClassUtil.scanPackageBySuper("com", CacheService.class)) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                continue;
            }
            try {
                CacheService cacheService = (CacheService) configurableContext.getBean(clazz);
                if (!cacheService.isInit()) {
                    cacheService.loadDatas();
                }
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("缓存初始化失败！", e);
            }
        }
    }

//    /******
//     * 根据token获取用户信息
//     * @param token
//     * @return
//     */
//    public SysUser getUserByToken(String token) {
//        return JSON.parseObject(redisUtil.get(CacheKeyConstants.PREFIX_TOKEN + token), SysUser.class);
//    }
}
