package com.kdgcsoft.jt.xzzf.common.ca;

import lombok.Data;

import java.io.Serializable;

/**
 * 签章图片实体类
 */
@Data
public class StampImageVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 签章图片base64
     */
    private String stampImage;
    /**
     *  图⽚位于PDF的X坐标
     */
    private int stampImageX;
    /**
     *  图⽚位于PDF的Y坐标
     */
    private int stampImageY;
    /**
     *  关键字
     */
    private String stampImageKeyWord;
    /**
     *  关键字索引
     */
    private int stampImageKeyWordIndex;
    /**
     *  图片缩放量（1-100）
     */
    private int stampImageScale;
    /**
     *  图片偏移量X
     */
    private int stampImageOffsetX;
    /**
     *  图片偏移量Y
     */
    private int stampImageOffsetY;

}
