/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.utils.id;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.id.NanoId;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortId {
    private static final Logger log = LoggerFactory.getLogger(ShortId.class);
    private static final char[] charArray = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz".toCharArray();
    private static final int scale = 8;

    public static String getId() {
        return NanoId.randomNanoId(null, (char[])charArray, (int)8);
    }

    public static String getId(String prefix) {
        if (StrUtil.isNotBlank((CharSequence)prefix)) {
            return prefix + "." + ShortId.getId();
        }
        return ShortId.getId();
    }

    public static void main(String[] args) {
        System.out.println(ShortId.getId());
        ArrayList<String> ids = new ArrayList<String>();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (int i = 0; i < 1000000; ++i) {
            ids.add(ShortId.getId());
        }
        stopWatch.stop();
        System.out.println(stopWatch.getTotalTimeMillis());
        System.out.println(ids.size());
        ArrayList newids = CollUtil.distinct(ids);
        System.out.println(newids.size());
        long nanotime = System.currentTimeMillis();
        System.out.println("nanotime:" + nanotime);
        System.out.println("nanotime:" + Long.toBinaryString(nanotime));
        System.out.println("nanotime:" + (nanotime << 12));
        System.out.println("nanotime:" + Long.toBinaryString(nanotime << 12));
        System.out.println("nanotime:" + (nanotime << 12 | 2L));
        System.out.println("nanotime:" + Long.toBinaryString(nanotime << 12 | 2L));
    }
}

