/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.utils;

import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.alibaba.fastjson2.JSON;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils
extends ServletUtil {
    public static final String USER_AGENT_HEADER = "User-Agent";

    public static UserAgent getUserAgent() {
        UserAgent userAgent = UserAgentUtil.parse((String)ServletUtil.getHeader((HttpServletRequest)ServletUtils.getRequest(), (String)USER_AGENT_HEADER, (Charset)StandardCharsets.UTF_8));
        return userAgent;
    }

    public static String getClientOS() {
        UserAgent userAgent = ServletUtils.getUserAgent();
        if (userAgent != null) {
            return userAgent.getPlatform().getName() + " " + userAgent.getOsVersion();
        }
        return "Unknown";
    }

    public static String getClientBrowser() {
        UserAgent userAgent = ServletUtils.getUserAgent();
        if (userAgent != null) {
            return userAgent.getBrowser().getName() + "(" + userAgent.getEngine().getName() + ")";
        }
        return "Unknown";
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        return response;
    }

    public static String getClientIp() {
        return ServletUtil.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
    }

    public static void renderJson(HttpServletResponse response, JsonResult json) {
        response.setCharacterEncoding("utf-8");
        ServletUtil.write((HttpServletResponse)response, (String)JSON.toJSONString((Object)json), (String)"application/json");
    }
}

