/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.utils;

import cn.dev33.satoken.exception.DisableServiceException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.SaTokenException;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.utils.CommonServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaTokenExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(SaTokenExceptionUtil.class);

    public static JsonResult buildJsonResult(Exception e) {
        JsonResult commonResult;
        if (e instanceof NotLoginException) {
            NotLoginException notLoginException = (NotLoginException)e;
            commonResult = JsonResult.ERROR(notLoginException.getMessage()).code(401);
        } else if (e instanceof NotRoleException) {
            NotRoleException notRoleException = (NotRoleException)e;
            commonResult = JsonResult.ERROR("\u65e0\u6b64\u89d2\u8272\uff1a" + notRoleException.getRole() + "\uff0c\u63a5\u53e3\u5730\u5740\uff1a" + CommonServletUtil.getRequest().getServletPath()).code(403);
        } else if (e instanceof NotPermissionException) {
            NotPermissionException notPermissionException = (NotPermissionException)e;
            commonResult = JsonResult.ERROR("\u65e0\u6b64\u6743\u9650\uff1a" + notPermissionException.getPermission()).code(403);
        } else if (e instanceof DisableServiceException) {
            DisableServiceException disableServiceException = (DisableServiceException)e;
            commonResult = JsonResult.ERROR("\u8d26\u53f7\u88ab\u5c01\u7981\uff1a" + disableServiceException.getDisableTime() + "\u79d2\u540e\u89e3\u5c01").code(403);
        } else if (e instanceof SaTokenException) {
            SaTokenException saTokenException = (SaTokenException)e;
            commonResult = JsonResult.ERROR(saTokenException.getMessage());
        } else {
            log.error(">>> \u670d\u52a1\u5668\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5177\u4f53\u4fe1\u606f\uff1a", (Object)CommonServletUtil.getRequest().getRequestURL(), (Object)e);
            commonResult = JsonResult.ERROR("\u670d\u52a1\u5668\u672a\u77e5\u5f02\u5e38");
        }
        return commonResult;
    }
}

