/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.utils;

import cn.dev33.satoken.exception.SaTokenException;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import com.kdgcsoft.iframe.web.common.pojo.JsonResult;
import com.kdgcsoft.iframe.web.common.utils.CommonServletUtil;
import com.kdgcsoft.iframe.web.common.utils.SaTokenExceptionUtil;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

public class GlobalExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionUtil.class);

    public static JsonResult buildJsonResult(Exception e) {
        JsonResult commonResult;
        if (e instanceof HttpRequestMethodNotSupportedException) {
            String method = CommonServletUtil.getRequest().getMethod();
            commonResult = HttpMethod.GET.toString().equals(method) ? JsonResult.ERROR("\u8bf7\u6c42\u65b9\u6cd5\u5e94\u4e3aPOST").code(405) : (HttpMethod.POST.toString().equals(method) ? JsonResult.ERROR("\u8bf7\u6c42\u65b9\u6cd5\u5e94\u4e3aGET").code(405) : JsonResult.ERROR("\u8bf7\u6c42\u65b9\u6cd5\u4ec5\u652f\u6301GET\u6216POST").code(405));
        } else if (e instanceof HttpMessageNotReadableException) {
            log.error(">>> \u53c2\u6570\u4f20\u9012\u683c\u5f0f\u5f02\u5e38\uff1a", (Throwable)e);
            commonResult = e.getMessage().contains("JSON parse error") ? JsonResult.ERROR("\u53c2\u6570\u683c\u5f0f\u9519\u8bef").code(415) : JsonResult.ERROR("\u8bf7\u4f7f\u7528JSON\u65b9\u5f0f\u4f20\u53c2").code(415);
        } else if (e instanceof HttpMediaTypeNotSupportedException) {
            log.error(">>> \u53c2\u6570\u4f20\u9012\u683c\u5f0f\u5f02\u5e38\uff1a", (Throwable)e);
            commonResult = JsonResult.ERROR("\u53c2\u6570\u683c\u5f0f\u9519\u8bef").code(415);
        } else if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException methodArgumentNotValidException = (MethodArgumentNotValidException)e;
            commonResult = JsonResult.ERROR(GlobalExceptionUtil.getArgNotValidMessage(methodArgumentNotValidException.getBindingResult())).code(415);
        } else if (e instanceof BindException) {
            BindException bindException = (BindException)e;
            commonResult = JsonResult.ERROR(GlobalExceptionUtil.getArgNotValidMessage(bindException.getBindingResult())).code(415);
        } else if (e instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)e;
            commonResult = JsonResult.ERROR(GlobalExceptionUtil.getArgNotValidMessage(constraintViolationException.getConstraintViolations())).code(415);
        } else if (e instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException missingServletRequestParameterException = (MissingServletRequestParameterException)e;
            commonResult = JsonResult.ERROR(missingServletRequestParameterException.getMessage()).code(415);
        } else if (e instanceof MultipartException) {
            log.error(">>> \u6587\u4ef6\u4e0a\u4f20\u53c2\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            commonResult = JsonResult.ERROR("\u8bf7\u4f7f\u7528multipart/form-data\u65b9\u5f0f\u4e0a\u4f20\u6587\u4ef6");
        } else if (e instanceof MissingServletRequestPartException) {
            log.error(">>> \u6587\u4ef6\u4e0a\u4f20\u53c2\u6570\u5f02\u5e38\uff1a", (Throwable)e);
            commonResult = JsonResult.ERROR("\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6\u5e76\u68c0\u67e5\u6587\u4ef6\u53c2\u6570\u540d\u79f0\u662f\u5426\u6b63\u786e");
        } else {
            if (e instanceof SaTokenException) {
                return SaTokenExceptionUtil.buildJsonResult(e);
            }
            if (e instanceof MyBatisSystemException) {
                Throwable cause = e.getCause();
                if (cause instanceof PersistenceException) {
                    Throwable secondCause = cause.getCause();
                    if (secondCause instanceof BizException) {
                        BizException commonException = (BizException)secondCause;
                        commonResult = JsonResult.ERROR(commonException.getMessage());
                    } else {
                        log.error(">>> \u6570\u636e\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
                        commonResult = JsonResult.ERROR("\u6570\u636e\u64cd\u4f5c\u5f02\u5e38");
                    }
                } else {
                    log.error(">>> \u6570\u636e\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
                    commonResult = JsonResult.ERROR("\u6570\u636e\u64cd\u4f5c\u5f02\u5e38");
                }
            } else if (e instanceof BizException) {
                BizException commonException = (BizException)e;
                commonResult = JsonResult.ERROR(commonException.getMessage());
            } else if (e instanceof NoHandlerFoundException) {
                NoHandlerFoundException error = (NoHandlerFoundException)e;
                commonResult = JsonResult.ERROR("\u672a\u77e5\u7684\u8bf7\u6c42\u5730\u5740:" + error.getHttpMethod() + " " + error.getRequestURL());
            } else {
                log.error(">>> \u670d\u52a1\u5668\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5177\u4f53\u4fe1\u606f\uff1a{}", (Object)CommonServletUtil.getRequest().getRequestURL(), (Object)e.getMessage());
                commonResult = JsonResult.ERROR().data(e.getMessage());
            }
        }
        return commonResult;
    }

    public static String getArgNotValidMessage(Set<ConstraintViolation<?>> constraintViolationSet) {
        if (ObjectUtil.isEmpty(constraintViolationSet)) {
            return "";
        }
        StringBuilder stringBuilder = StrUtil.builder();
        for (ConstraintViolation<?> constraintViolation : constraintViolationSet) {
            stringBuilder.append(",").append(constraintViolation.getMessage());
        }
        return StrUtil.removePrefix((CharSequence)stringBuilder.toString(), (CharSequence)",");
    }

    public static String getArgNotValidMessage(BindingResult bindingResult) {
        if (ObjectUtil.isNull((Object)bindingResult)) {
            return "";
        }
        StringBuilder stringBuilder = StrUtil.builder();
        List allErrorInfos = bindingResult.getAllErrors();
        for (ObjectError error : allErrorInfos) {
            stringBuilder.append(",").append(error.getDefaultMessage());
        }
        return StrUtil.removePrefix((CharSequence)stringBuilder.toString(), (CharSequence)",");
    }
}

