/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.utils;

import cn.hutool.core.util.ObjectUtil;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CommonServletUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonServletUtil.class);

    public static String getParamFromRequest(String paramName) {
        Cookie[] cookies;
        HttpServletRequest request = CommonServletUtil.getRequest();
        String paramValue = request.getParameter(paramName);
        if (ObjectUtil.isEmpty((Object)paramValue)) {
            paramValue = request.getHeader(paramName);
        }
        if (ObjectUtil.isEmpty((Object)paramValue) && ObjectUtil.isNotEmpty((Object)(cookies = request.getCookies()))) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!cookieName.equals(paramName)) continue;
                return cookie.getValue();
            }
        }
        return paramValue;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes;
        try {
            servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        }
        catch (Exception e) {
            log.error(">>> \u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Request\uff1a", (Throwable)e);
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Request", e);
        }
        if (servletRequestAttributes == null) {
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Request");
        }
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes;
        try {
            servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        }
        catch (Exception e) {
            log.error(">>> \u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Response\uff1a", (Throwable)e);
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Response", e);
        }
        if (servletRequestAttributes == null) {
            throw new BizException("\u975eWeb\u4e0a\u4e0b\u6587\u65e0\u6cd5\u83b7\u53d6Response");
        }
        return servletRequestAttributes.getResponse();
    }

    public static boolean isWeb() {
        return RequestContextHolder.getRequestAttributes() != null;
    }
}

