/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.utils;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.iframe.web.common.exception.BizException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CascadeUtil {
    public static void main(String[] args) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> a = new HashMap<String, Object>();
        a.put("key", 1);
        a.put("pkey", 0);
        a.put("text", "a");
        data.add(a);
        HashMap<String, Object> a1 = new HashMap<String, Object>();
        a1.put("key", 2);
        a1.put("pkey", 1);
        a1.put("text", "a1");
        data.add(a1);
        HashMap<String, Object> a2 = new HashMap<String, Object>();
        a2.put("key", 3);
        a2.put("pkey", 1);
        a2.put("text", "a2");
        data.add(a2);
        HashMap<String, Object> a11 = new HashMap<String, Object>();
        a11.put("key", 4);
        a11.put("pkey", 2);
        a11.put("text", "a11");
        data.add(a11);
        HashMap<String, Object> b = new HashMap<String, Object>();
        b.put("key", 5);
        b.put("pkey", 0);
        b.put("text", "b");
        data.add(b);
        CascadeUtil.cascade(data, "key", "pkey", "text", "cascade", "-");
        System.out.println(JSON.toJSONString(data));
    }

    public static void cascade(Collection<Map<String, Object>> data, String key, String parentKey, String text, String cascadeText, String connector) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        String childrenLabel = "children";
        HashMap<Object, Map<String, Object>> map = new HashMap<Object, Map<String, Object>>();
        for (Map<String, Object> item : data) {
            map.put(item.get(key), item);
        }
        try {
            for (Map<String, Object> item : data) {
                Object keyVal = item.get(key);
                Object parentVal = item.get(parentKey);
                map.put(keyVal, item);
                if (CascadeUtil.isRootNode(parentVal)) continue;
                Map parent = (Map)map.get(parentVal);
                if (!parent.containsKey(childrenLabel)) {
                    parent.put(childrenLabel, new ArrayList());
                }
                List children = (List)parent.get(childrenLabel);
                children.add(item);
            }
            List pool = map.values().stream().filter(row -> CascadeUtil.isRootNode(row.get(parentKey))).collect(Collectors.toList());
            while (pool.size() > 0) {
                Map current = (Map)pool.remove(0);
                Object parentVal = current.get(parentKey);
                Object cascadeVal = CascadeUtil.isRootNode(parentVal) ? (String)current.get(text) : current.get(cascadeText) + connector + current.get(text);
                current.put(cascadeText, cascadeVal);
                List children = (List)current.remove(childrenLabel);
                if (!CollUtil.isNotEmpty((Collection)children)) continue;
                for (Map item : children) {
                    item.put(cascadeText, cascadeVal);
                }
                pool.addAll(children);
            }
        }
        catch (Exception e) {
            throw new BizException(e.getMessage(), e);
        }
    }

    private static boolean isRootNode(Object parentValue) {
        if (null == parentValue) {
            return true;
        }
        if (parentValue instanceof String) {
            return ((String)parentValue).trim().equals("0");
        }
        if (parentValue instanceof Integer) {
            return (Integer)parentValue == 0;
        }
        if (parentValue instanceof Long) {
            return (Long)parentValue == 0L;
        }
        return false;
    }
}

