/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.pojo;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class JsonResult<T>
implements Serializable {
    private Boolean success = true;
    private int code = 200;
    private String msg = "\u64cd\u4f5c\u6210\u529f";
    private T data;

    public JsonResult() {
    }

    public JsonResult(boolean success, String message) {
        this.success = success;
        this.msg = message;
    }

    public static JsonResult OK() {
        return JsonResult.OK("\u64cd\u4f5c\u6210\u529f");
    }

    public static JsonResult OK(String message) {
        return new JsonResult(true, message);
    }

    public static JsonResult OK(String messageTemplate, Object ... params) {
        String message = StrUtil.format((CharSequence)messageTemplate, (Object[])params);
        return JsonResult.OK(message);
    }

    public static JsonResult ERROR() {
        return JsonResult.ERROR("\u64cd\u4f5c\u5931\u8d25");
    }

    public static JsonResult ERROR(String message) {
        return new JsonResult(false, message);
    }

    public static JsonResult ERROR(String messageTemplate, Object ... params) {
        String message = StrUtil.format((CharSequence)messageTemplate, (Object[])params);
        return JsonResult.ERROR(message);
    }

    public JsonResult data(T data) {
        this.data = data;
        return this;
    }

    public JsonResult msg(String msg) {
        this.msg = msg;
        return this;
    }

    public JsonResult code(int code) {
        this.code = code;
        return this;
    }

    public JsonResult setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public JsonResult ifSuccessOfElse(Consumer<JsonResult> successAction, Consumer<JsonResult> errorAction) {
        if (this.success.booleanValue()) {
            successAction.accept(this);
        } else {
            errorAction.accept(this);
        }
        return this;
    }

    public JsonResult successThen(Supplier<? extends JsonResult> supplier) {
        if (this.success.booleanValue()) {
            return supplier.get();
        }
        return this;
    }

    public JsonResult errorThen(Supplier<JsonResult> supplier) {
        if (!this.success.booleanValue()) {
            return supplier.get();
        }
        return this;
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }
}

