/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.common.controller;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.common.utils.MimeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.ModelAndView;

public class BaseController {
    @Autowired
    public HttpServletRequest request;
    @Autowired
    public HttpServletResponse response;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(10000);
    }

    public HttpHeaders buildDownloadHeader(String fileName) {
        try {
            if (StrUtil.isBlank((CharSequence)this.request.getHeader("User-Agent"))) {
                fileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            } else {
                String header = this.request.getHeader("User-Agent").toUpperCase();
                if (header.contains("MSIE") || header.contains("TRIDENT") || header.contains("EDGE")) {
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replaceAll("\\+", "%20");
                } else {
                    fileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        return headers;
    }

    public ResponseEntity<FileSystemResource> renderFile(File file) {
        if (file == null) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(file.getName()))).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new FileSystemResource(file));
    }

    public ResponseEntity<InputStreamResource> renderFile(InputStream inputStream, String fileName, long size) {
        if (inputStream == null) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(fileName))).contentLength(size).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new InputStreamResource(inputStream));
    }

    public ResponseEntity<FileSystemResource> renderFile(File file, String fileType) {
        if (file == null) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(file.getName()))).contentLength(file.length()).contentType(MediaType.parseMediaType((String)fileType)).body((Object)new FileSystemResource(file));
    }

    public ResponseEntity<ByteArrayResource> renderFile(byte[] bytes, String fileType, String fileName) {
        if (bytes.length < 1) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(fileName))).contentLength((long)bytes.length).contentType(StrUtil.isNotEmpty((CharSequence)fileType) ? MediaType.parseMediaType((String)fileType) : MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(bytes));
    }

    public ResponseEntity<ByteArrayResource> renderFile(byte[] bytes, String fileName) {
        if (bytes.length < 1) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(fileName))).contentLength((long)bytes.length).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(bytes));
    }

    public void renderImage(byte[] bytes, String imageName) {
        String contentType = MimeUtil.getMimeType(imageName);
        this.response.setContentType(contentType);
        ServletOutputStream os = null;
        try {
            os = this.response.getOutputStream();
            os.write(bytes);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ModelAndView view(String viewname) {
        return this.view(viewname, null);
    }

    public ModelAndView view(String viewname, Map<String, Object> modelMap) {
        ModelAndView view = new ModelAndView();
        view.setViewName(viewname);
        view.addAllObjects(modelMap);
        return view;
    }

    public ModelAndView view(ModelAndView view, Map<String, Object> modelMap) {
        view.addAllObjects(modelMap);
        return view;
    }

    public Map<String, Object> getParamsMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map map = this.request.getParameterMap();
        for (String key : map.keySet()) {
            Object[] values = (String[])map.get(key);
            params.put(key, ArrayUtil.join((Object[])values, (CharSequence)","));
        }
        return params;
    }
}

