-- liquibase formatted sql
-- changeset fyin:iframe-web-config-0.0.1
-- comment: iframe-web-config初始化脚本

/*==============================================================*/
/* Table: base_dict                                             */
/*==============================================================*/
create table if not exists base_dict (
                                         dict_id              int8                 not null,
                                         dict_code            varchar(32)          null,
    dict_name            varchar(128)         null,
    dict_type            varchar(32)          null,
    embed                int2                 null,
    ord_no               int8                 null,
    rmk                  varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint base_dict_pk primary key (dict_id)
    );

comment on table base_dict is
'数据字典';

comment on column base_dict.dict_id is
'数据字典id';

comment on column base_dict.dict_code is
'字典编码';

comment on column base_dict.dict_name is
'字典名称';

comment on column base_dict.dict_type is
'字典类型';

comment on column base_dict.embed is
'是否内置';

comment on column base_dict.ord_no is
'排序';

comment on column base_dict.rmk is
'备注';

comment on column base_dict.deleted is
'是否删除';

comment on column base_dict.create_by is
'创建人';

comment on column base_dict.create_time is
'创建时间';

comment on column base_dict.modify_by is
'修改人';

comment on column base_dict.modify_time is
'修改时间';


/*==============================================================*/
/* Table: base_dict_item                                        */
/*==============================================================*/
create table if not exists base_dict_item (
                                              dict_item_id         int8                 not null,
                                              dict_item_pid        int8                 null,
                                              dict_id              int8                 null,
                                              dict_code            varchar(32)          null,
    value                varchar(32)          null,
    text                 varchar(128)         null,
    embed                int2                 null,
    enabled              int2                 null,
    ord_no               int8                 null,
    rmk                  varchar(512)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint base_dict_item_pk primary key (dict_item_id)
    );

comment on table base_dict_item is
'数据字典项';

comment on column base_dict_item.dict_item_id is
'数据字典项id';

comment on column base_dict_item.dict_item_pid is
'上级字典项id';

comment on column base_dict_item.dict_id is
'数据字典id';

comment on column base_dict_item.dict_code is
'字典编码';

comment on column base_dict_item.value is
'数据值';

comment on column base_dict_item.text is
'数据名称';

comment on column base_dict_item.embed is
'是否内置';

comment on column base_dict_item.enabled is
'是否启用';

comment on column base_dict_item.ord_no is
'排序';

comment on column base_dict_item.rmk is
'备注';

comment on column base_dict_item.deleted is
'是否删除';

comment on column base_dict_item.create_by is
'创建人';

comment on column base_dict_item.create_time is
'创建时间';

comment on column base_dict_item.modify_by is
'修改人';

comment on column base_dict_item.modify_time is
'修改时间';


/*==============================================================*/
/* Table: base_menu                                             */
/*==============================================================*/
create table if not exists base_menu (
                                         menu_id              int8                 not null,
                                         menu_pid             int8                 null,
                                         menu_code            varchar(32)          null,
    menu_name            varchar(128)         null,
    url                  varchar(256)         null,
    icon                 varchar(32)          null,
    open_type            varchar(32)          null,
    embed                int2                 null,
    enabled              int2                 null,
    ord_no               int8                 null,
    rmk                  varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint base_menu_pk primary key (menu_id)
    );

comment on table base_menu is
'菜单配置';

comment on column base_menu.menu_id is
'菜单id';

comment on column base_menu.menu_pid is
'上级菜单';

comment on column base_menu.menu_code is
'菜单编码';

comment on column base_menu.menu_name is
'菜单名称';

comment on column base_menu.url is
'菜单地址';

comment on column base_menu.icon is
'菜单图标';

comment on column base_menu.open_type is
'打开方式';

comment on column base_menu.embed is
'是否内置';

comment on column base_menu.enabled is
'是否启用';

comment on column base_menu.ord_no is
'排序';

comment on column base_menu.rmk is
'备注';

comment on column base_menu.deleted is
'是否删除';

comment on column base_menu.create_by is
'创建人';

comment on column base_menu.create_time is
'创建时间';

comment on column base_menu.modify_by is
'修改人';

comment on column base_menu.modify_time is
'修改时间';


/*==============================================================*/
/* Table: base_param                                            */
/*==============================================================*/
create table if not exists base_param (
                                          param_id             int8                 not null,
                                          param_code           varchar(32)          null,
    param_name           varchar(128)         null,
    param_group          varchar(64)          null,
    param_value          varchar(256)         null,
    default_value        varchar(256)         null,
    param_type           varchar(64)          null,
    embed                int2                 null,
    anon_access          int2                 null,
    param_options        text                 null,
    rmk                  varchar(256)         null,
    deleted              int2                 null,
    create_by            int8                 null,
    create_time          timestamp            null,
    modify_by            int8                 null,
    modify_time          timestamp            null,
    constraint base_param_pk primary key (param_id)
    );

comment on table base_param is
'系统参数';

comment on column base_param.param_id is
'参数id';

comment on column base_param.param_code is
'参数编码';

comment on column base_param.param_name is
'参数名称';

comment on column base_param.param_group is
'参数分组';

comment on column base_param.param_value is
'参数值';

comment on column base_param.default_value is
'默认值';

comment on column base_param.param_type is
'参数类型';

comment on column base_param.embed is
'是否内置';

comment on column base_param.anon_access is
'匿名访问';

comment on column base_param.param_options is
'配置项';

comment on column base_param.rmk is
'备注';

comment on column base_param.deleted is
'是否删除';

comment on column base_param.create_by is
'创建人';

comment on column base_param.create_time is
'创建时间';

comment on column base_param.modify_by is
'修改人';

comment on column base_param.modify_time is
'修改时间';


/*==============================================================*/
/* Table: base_log_login                                        */
/*==============================================================*/
create table if not exists base_log_login (
                                              log_login_id         int8                 not null,
                                              user_id              int8                 null,
                                              login_type           varchar(32)          null,
                                              log_ip               varchar(32)          null,
                                              log_os               varchar(128)         null,
                                              log_browser          varchar(128)         null,
                                              successed            int2                 null,
                                              log_result           varchar(128)         null,
                                              log_time             timestamp            null,
                                              deleted              int2                 null,
                                              create_by            int8                 null,
                                              create_time          timestamp            null,
                                              modify_by            int8                 null,
                                              modify_time          timestamp            null,
                                              constraint base_log_login_pk primary key (log_login_id)
);

comment on table base_log_login is
    '日志-登录日志';

comment on column base_log_login.log_login_id is
    '登录日志id';

comment on column base_log_login.user_id is
    '用户id';

comment on column base_log_login.login_type is
    '日志类型';

comment on column base_log_login.log_ip is
    'ip地址';

comment on column base_log_login.log_os is
    '操作系统';

comment on column base_log_login.log_browser is
    '浏览器';

comment on column base_log_login.successed is
    '是否成功';

comment on column base_log_login.log_result is
    '登录结果';

comment on column base_log_login.log_time is
    '日志时间';

comment on column base_log_login.deleted is
    '是否删除';

comment on column base_log_login.create_by is
    '创建人';

comment on column base_log_login.create_time is
    '创建时间';

comment on column base_log_login.modify_by is
    '修改人';

comment on column base_log_login.modify_time is
    '修改时间';


/*==============================================================*/
/* Table: base_log_opt                                          */
/*==============================================================*/
create table if not exists base_log_opt (
                                            log_opt_id           int8                 not null,
                                            user_id              int8                 null,
                                            opt_title            varchar(128)         null,
                                            request_url          varchar(256)         null,
                                            http_method          varchar(32)          null,
                                            java_method          varchar(256)         null,
                                            opt_type             varchar(32)          null,
                                            opt_ip               varchar(32)          null,
                                            time_cost            int8                 null,
                                            opt_time             timestamp            null,
                                            request_content      text                 null,
                                            response_result      text                 null,
                                            successed            int2                 null,
                                            opt_description      varchar(256)         null,
                                            deleted              int2                 null,
                                            create_by            int8                 null,
                                            create_time          timestamp            null,
                                            modify_by            int8                 null,
                                            modify_time          timestamp            null,
                                            constraint base_log_opt_pk primary key (log_opt_id)
);

comment on table base_log_opt is
    '日志-操作日志';

comment on column base_log_opt.log_opt_id is
    '操作日志id';

comment on column base_log_opt.user_id is
    '用户id';

comment on column base_log_opt.opt_title is
    '操作标题';

comment on column base_log_opt.request_url is
    '请求地址';

comment on column base_log_opt.http_method is
    '请求方式';

comment on column base_log_opt.java_method is
    'java方法';

comment on column base_log_opt.opt_type is
    '操作类型';

comment on column base_log_opt.opt_ip is
    'ip地址';

comment on column base_log_opt.time_cost is
    '耗时';

comment on column base_log_opt.opt_time is
    '操作时间';

comment on column base_log_opt.request_content is
    '请求内容';

comment on column base_log_opt.response_result is
    '响应结果';

comment on column base_log_opt.successed is
    '是否成功';

comment on column base_log_opt.opt_description is
    '文字描述';

comment on column base_log_opt.deleted is
    '是否删除';

comment on column base_log_opt.create_by is
    '创建人';

comment on column base_log_opt.create_time is
    '创建时间';

comment on column base_log_opt.modify_by is
    '修改人';

comment on column base_log_opt.modify_time is
    '修改时间';



