/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.config.onlinelog;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.iframe.web.config.onlinelog.LoggerDisruptorQueue;
import com.kdgcsoft.iframe.web.config.onlinelog.LoggerMessage;
import java.util.Date;

public class OnlineLogFilter
extends Filter<ILoggingEvent> {
    public FilterReply decide(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        if (event.getMessage().contains("/logger/onlineLogger") || event.getMessage().contains("Broadcasting to 1 sessions.")) {
            return FilterReply.DENY;
        }
        int line = 0;
        if (cda != null && cda.length > 0) {
            line = cda[0].getLineNumber();
        }
        LoggerMessage loggerMessage = new LoggerMessage(event.getFormattedMessage(), DateUtil.format((Date)new java.sql.Date(event.getTimeStamp()), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT), StrUtil.fillBefore((String)event.getThreadName(), (char)' ', (int)15), event.getLoggerName(), StrUtil.fillAfter((String)event.getLevel().levelStr, (char)' ', (int)5), StrUtil.fillAfter((String)String.valueOf(line), (char)' ', (int)4));
        LoggerDisruptorQueue.publishEvent(loggerMessage);
        return FilterReply.NEUTRAL;
    }
}

