/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.config.onlinelog;

import cn.hutool.core.thread.NamedThreadFactory;
import com.kdgcsoft.iframe.web.config.onlinelog.LoggerMessage;
import com.kdgcsoft.iframe.web.config.onlinelog.disruptor.OnlineLoggerEvent;
import com.kdgcsoft.iframe.web.config.onlinelog.disruptor.OnlineLoggerEventFactory;
import com.kdgcsoft.iframe.web.config.onlinelog.disruptor.OnlineLoggerEventHandler;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoggerDisruptorQueue {
    private OnlineLoggerEventFactory factory = new OnlineLoggerEventFactory();
    private int bufferSize = 2048;
    private Disruptor<OnlineLoggerEvent> onlineLoggerEventDisruptor = new Disruptor((EventFactory)this.factory, this.bufferSize, (ThreadFactory)new NamedThreadFactory("onlinelog", false));
    private static RingBuffer<OnlineLoggerEvent> onlineLoggerEventRingBuffer;

    @Autowired
    LoggerDisruptorQueue(OnlineLoggerEventHandler eventHandler) {
        this.onlineLoggerEventDisruptor.handleEventsWith(new EventHandler[]{eventHandler});
        onlineLoggerEventRingBuffer = this.onlineLoggerEventDisruptor.getRingBuffer();
        this.onlineLoggerEventDisruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishEvent(LoggerMessage log) {
        if (onlineLoggerEventRingBuffer == null) {
            return;
        }
        long sequence = onlineLoggerEventRingBuffer.next();
        try {
            OnlineLoggerEvent event = (OnlineLoggerEvent)onlineLoggerEventRingBuffer.get(sequence);
            event.setLog(log);
        }
        finally {
            onlineLoggerEventRingBuffer.publish(sequence);
        }
    }
}

