/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.iframe.web.base.service;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.kdgcsoft.iframe.web.common.config.IFrameProperties;
import com.kdgcsoft.iframe.web.common.utils.ServletUtils;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class IFrameService {
    private static final Logger log = LoggerFactory.getLogger(IFrameService.class);
    @Autowired
    IFrameProperties iFrameProperties;
    @Value(value="${iframe.doc.preview.url:}")
    private String docPreviewUrl;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Autowired
    private ServletWebServerApplicationContext webServerApplicationContext;

    public String getServerUrl() {
        if (StrUtil.isNotBlank((CharSequence)this.iFrameProperties.getServerUrl())) {
            return this.iFrameProperties.getServerUrl();
        }
        String protocol = "http";
        try {
            HttpServletRequest request = ServletUtils.getRequest();
            log.info("\u540e\u7aef\u83b7\u53d6\u7684\u8bf7\u6c42\u5730\u5740:" + request.getRequestURL().toString());
            URL url = URLUtil.url((String)request.getRequestURL().toString());
            protocol = url.getProtocol();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int port = this.webServerApplicationContext.getWebServer().getPort();
        String serverUrl = protocol + "://" + NetUtil.getLocalhostStr() + (String)(port != 80 ? ":" + port : "") + this.contextPath;
        log.info("\u672c\u5730\u5e94\u7528\u5730\u5740:" + serverUrl);
        return serverUrl;
    }
}

